DELIMITER $$
DROP PROCEDURE IF EXISTS V20241025170102__Alter_studentCEQdetails $$
CREATE PROCEDURE V20241025170102__Alter_studentCEQdetails()
BEGIN

IF EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_sceqde_programBatchCourseDetailsId' AND table_name='student_course_enrollment_Queue_details_entry')  then
ALTER TABLE student_course_enrollment_Queue_details_entry DROP FOREIGN KEY fk_sceqde_programBatchCourseDetailsId;
END IF;

IF EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_sceqde_studentCourseEnrollmentId' AND table_name='student_course_enrollment_Queue_details_entry')  then
ALTER TABLE student_course_enrollment_Queue_details_entry DROP FOREIGN KEY fk_sceqde_studentCourseEnrollmentId;
END IF;

IF EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and column_name='programBatchCourseDetailsId' and table_name='student_course_enrollment_Queue_details_entry' and index_name='fk_sceqde_programBatchCourseDetailsId_idx') then
ALTER TABLE student_course_enrollment_Queue_details_entry DROP index fk_sceqde_programBatchCourseDetailsId_idx;
END IF;

IF EXISTS (SELECT index_name FROM information_schema.statistics where table_schema=database() and column_name='studentCourseEnrollmentId' and table_name='student_course_enrollment_Queue_details_entry' and index_name='fk_sceqde_studentCourseEnrollmentId_idx') then
ALTER TABLE student_course_enrollment_Queue_details_entry DROP index fk_sceqde_studentCourseEnrollmentId_idx;
END IF;



IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_sceqde_programBatchCourseDetailsId' AND table_name='student_course_enrollment_Queue_details_entry') then
ALTER TABLE student_course_enrollment_Queue_details_entry ADD CONSTRAINT fk_sceqde_programBatchCourseDetailsId
  FOREIGN KEY (programBatchCourseDetailsId)
  REFERENCES prog_batch_course_details (id)
  ON DELETE CASCADE
  ON UPDATE RESTRICT;
  END IF;

  IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_sceqde_studentCourseEnrollmentId' AND table_name='student_course_enrollment_Queue_details_entry') then
ALTER TABLE student_course_enrollment_Queue_details_entry ADD CONSTRAINT fk_sceqde_studentCourseEnrollmentId
  FOREIGN KEY (studentCourseEnrollmentId)
  REFERENCES student_course_enrollment (id)
  ON DELETE CASCADE
  ON UPDATE RESTRICT;

END IF; 

END $$
CALL V20241025170102__Alter_studentCEQdetails() $$
DROP PROCEDURE IF EXISTS V20241025170102__Alter_studentCEQdetails $$
DELIMITER ;