DELIMITER $$
DROP PROCEDURE IF EXISTS V20241104155451__Create_Academia_LimeSurvey $$
CREATE PROCEDURE V20241104155451__Create_Academia_LimeSurvey()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academia_lime_survey') THEN 
CREATE TABLE academia_lime_survey (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
    surveyId BIGINT UNIQUE,
    surveyName VARCHAR(255),
    status VARCHAR(50),
    academyLocationId BIGINT,
	academicTermId BIGINT,
    courseId BIGINT,
    courseVarientId BIGINT,
    programId BIGINT,
    batchId BIGINT,
    periodId BIGINT,
    facultyId BIGINT,
	surveyStartDate DATETIME,
	surveyEndDate DATETIME,	
	lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	lastUpdatedBy BIGINT(20) DEFAULT NULL,
	PRIMARY KEY (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_academyLocationId` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_academicTermId` FOREIGN KEY (`academicTermId`) REFERENCES `academic_term` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_courseId` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_courseVarientId` FOREIGN KEY (`courseVarientId`) REFERENCES `course_variants` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_programId` FOREIGN KEY (`programId`) REFERENCES `programs` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
	CONSTRAINT `FK_Academia_LimeSurvey_facultyId` FOREIGN KEY (`facultyId`) REFERENCES `staffs` (`userId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20241104155451__Create_Academia_LimeSurvey () $$ 
DROP PROCEDURE IF EXISTS V20241104155451__Create_Academia_LimeSurvey $$ 
DELIMITER ;