DELIMITER $$
DROP PROCEDURE IF EXISTS fatchUsersToBePushInBB $$
CREATE PROCEDURE fatchUsersToBePushInBB()
BEGIN
SELECT
    user.id as id,
    user.code as userCode,
    user.printName as userName,
    user.firstName as given,
    user.lastName as family,
    user.middleName as middle,
    stuPer.emailId as email,
    stuPer.birthDate  as birthDate,
	gen.itemValue as gender,
    'STUDENT'   as role
FROM
    users AS user
		JOIN
    students AS stu ON stu.userId = user.id
        left JOIN
	blackboard_user_mapping as userMapping ON userMapping.academiaUserId=user.id
		JOIN 
	admission as ad on (ad.studentId=user.id and ad.activeStatus=true)
		JOIN 
	program_batch_students as pbs on (pbs.admissionId=ad.id and pbs.promotionEnrollmentStatus="ENROLLED" and pbs.exitDate is null)
        JOIN 
    persons AS stuPer ON stuPer.id = stu.personId
        JOIN 
	gender as gen On gen.id = stuPer.genderId
		JOIN 
    user_academy_locations AS ual ON ual.userId = user.id
        JOIN 
    user_acad_loc_roles AS ualr ON ualr.userAcadLocationId = ual.id
        JOIN 
    roles AS role ON role.id = ualr.roleId
    where userMapping.id is null and role.roleName ="STUDENT" 
     and admissionId in(SELECT distinct ad.id AS admissionId FROM admission ad
							    JOIN student_course_enrollment sce ON ad.id = sce.admissionId
								JOIN program_batch_students as pbs ON (pbs.admissionId=sce.admissionId and pbs.promotionEnrollmentStatus="ENROLLED" and pbs.exitDate is null)	
                                JOIN prog_batch_seat_config as pbsc ON pbs.progBatchSeatConfigId=pbsc.id
                                JOIN seat_types as seatType ON (seatType.id=pbsc.seatTypeId and seatType.seatName not in(select value from drop_down where type='Blackboard_Seattype_SkipRules'))
								JOIN bill_header bh ON sce.billId = bh.id
							    WHERE bh.billStatus in  ('SETTLED','PARTLY_SETTLED')
						UNION SELECT distinct ad.id AS admissionId FROM admission ad
								JOIN students as st on ad.studentId=st.userId
                                JOIN program_batch_students as pbs ON (pbs.admissionId=ad.id and pbs.promotionEnrollmentStatus="ENROLLED" and pbs.exitDate is null)
                                JOIN prog_batch_seat_config as pbsc ON pbs.progBatchSeatConfigId=pbsc.id
                                JOIN seat_types as seatType ON (seatType.id=pbsc.seatTypeId and seatType.seatName in(select value from drop_down where type='Blackboard_Seattype_SkipRules'))
								JOIN bill_header bh ON pbs.progBatchPeriodConfigId=bh.programBatchPeriodConfigId and pbs.progBatchSeatConfigId=bh.programBatchSeatConfigId and bh.studentId=st.userId
								WHERE bh.billStatus in  ('SETTLED','PARTLY_SETTLED')) group by user.id;
END $$ 
DELIMITER ;