DELIMITER $$
DROP PROCEDURE IF EXISTS V20241105143917__Create_Academia_LimeSurvey_Participant $$
CREATE PROCEDURE V20241105143917__Create_Academia_LimeSurvey_Participant()
BEGIN

IF NOT EXISTS (SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academia_lime_survey_participant') THEN 
CREATE TABLE academia_lime_survey_participant (
	id BIGINT(20) NOT NULL AUTO_INCREMENT,
    academiaLimeSurveyId BIGINT,
    firstName VARCHAR(50),
    lastName VARCHAR(50),
    email VARCHAR(255),
    accessCode VARCHAR(255),
    studentId BIGINT,
    applicantPersonId BIGINT,
    isSurveyEnrolled BOOLEAN DEFAULT FALSE,
    eamilSent BOOLEAN DEFAULT FALSE,	
	lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	lastUpdatedBy BIGINT(20) DEFAULT NULL,
	PRIMARY KEY (`id`),
	CONSTRAINT `FK_academia_lime_survey_participant_academiaLimeSurveyId` FOREIGN KEY (`academiaLimeSurveyId`) REFERENCES `academia_lime_survey` (`id`),
	CONSTRAINT `FK_academia_lime_survey_participant_studentId` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
	CONSTRAINT `FK_academia_lime_survey_participant_applicantPersonId` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`)	
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

END $$
CALL V20241105143917__Create_Academia_LimeSurvey_Participant () $$ 
DROP PROCEDURE IF EXISTS V20241105143917__Create_Academia_LimeSurvey_Participant $$ 
DELIMITER ;