DELIMITER $$
DROP PROCEDURE IF EXISTS V20241106104417__Insert_SchAwardLetterStudentDocSupport $$
CREATE PROCEDURE V20241106104417__Insert_SchAwardLetterStudentDocSupport()
BEGIN

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM sql_dtprovider WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_STUDENT_DL'))) THEN

UPDATE sql_dtprovider SET sqlQuery="SELECT DISTINCT T1.id AS USER_ID, T2.academyLocationId AS ACADEMY_LOCATION_IDS FROM scholarship_nominate_or_award T1 INNER JOIN programs T2 ON T2.id=T1.programId WHERE T1.id IN (namedParams)" 
WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_STUDENT_DL');

END IF;

IF EXISTS ((SELECT * FROM sql_dtprovider WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_STUDENT_RECIPIENT'))) THEN

UPDATE sql_dtprovider SET sqlQuery=
"SELECT DISTINCT
    T1.id AS ID,
    T3.printName AS STUDENT_PRINT_NAME,
    T3.firstName AS FIRST_NAME,
    T3.middleName AS MIDDLE_NAME,
    T3.lastName AS LAST_NAME,
    T3.emailId AS EMAIL_ID,
    T3.code AS STUDENT_ID,
    CURDATE() AS CURRENT_DATE_TODAY,
    T19.externalSysRefOne AS STUDENT_EXTERNAL_REFERENCE_NUMBER_1,
    T4.programName AS PROGRAM,
    T5.batchName AS BATCH,
    T8.scholarshipCode AS SCHOLARSHIP_ID,
    T8.scholarshipName AS SCHOLARSHIP_NAME,
    T8.scholarshipCategory AS SCHOLARSHIP_CATEGORY,
    T1.amount AS SCHOLARSHIP_AMOUNT,
    T11.printName AS SCHOLARSHIP_OWNER_NAME,
    T11.emailId AS SCHOLARSHIP_OWNER_EMAIL,
    T13.displayName AS AL,
    T20.addressText AS CURRENT_ADRESS,
    T15.cityName AS CITY,
    T16.countryName AS COUNTRY,
    T20.pincode AS PIN_CODE,
    T22.programPeriodName AS PERIOD
    
FROM
    scholarship_nominate_or_award T1
        LEFT OUTER JOIN
    students T2 ON T1.studentId = T2.userId    
        LEFT OUTER JOIN
    users T3 ON T2.userId = T3.id
        LEFT OUTER JOIN    
    admission T23 ON T23.studentId = T3.id
        LEFT OUTER JOIN  
	prog_batch_period_config T22 ON T22.id = T23.programBatchPeriodConfigId
      LEFT OUTER JOIN  
    programs T4 ON T1.programId = T4.id
       LEFT OUTER JOIN
    batches T5 ON T1.batchId = T5.id
       LEFT OUTER JOIN
    prog_batch_seat_config T6 ON T6.programBatchId= T5.id
       LEFT OUTER JOIN
    scholarship T8 ON T8.id = T1.scholarshipId
      LEFT OUTER JOIN
    scholarship_owners T10 ON  T10.scholarshipId=T8.id
     LEFT OUTER JOIN
    users T11 ON T10.ownerId=T11.id
      LEFT OUTER JOIN
    academy_location T13 ON T13.id=T4.academyLocationId
      LEFT OUTER JOIN 
    person_addresses T14 ON T14.personId = T3.id
      LEFT OUTER JOIN
    address T20 ON T14.addressId= T20.id
        LEFT OUTER JOIN
    city T15 on  T15.id=T20.cityId
      LEFT OUTER JOIN 
    country T16 ON T16.id=T20.countryId
      LEFT OUTER JOIN 
    address_type T17 ON T14.addressTypeId=T17.id
      LEFT OUTER JOIN 
    persons T19 ON T2.personId = T19.id
       
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=(SELECT id FROM dtprovider WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_STUDENT_RECIPIENT');

END IF;
	
IF EXISTS ((SELECT * FROM msg_category WHERE `code`='SCH_NOMINATION_AWARDED_STUDENT')) THEN

IF NOT EXISTS ((SELECT * FROM dydt_document_type WHERE `typeName`='Scholarship Award Letter - Student')) THEN

SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`)
VALUES (@dydtdocumenttypeId+1,'Scholarship Award Letter - Student', 'ACADEMY_LOCATION_LEVEL', '0', 'Scholarship Award Letter - Student', '0', '1');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf` WHERE `distrListProviderId`=(SELECT `id` FROM `dtprovider` WHERE `dataProviderName`='SCH_NOMINATION_AWARDED_STUDENT_DL'));
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{"MSG_PARAM":"CONTEXT_RECORD_ID","DOC_GEN_PARAM":"PRM_SCHOLARSHIP_AWARD_LETTER_STUDENT_ID"}]');
-- Start : Mapping of Dynamic Document to MsgTemplate
SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
SET @msgtemplateconfigId=(SELECT MAX(id) FROM `msg_template_config` WHERE `code`='Scholarship Nomination Awarded Student');
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId,@sysmsgevtrcpntdocId+1);
-- End : Mapping of Dynamic Document to Msgtemplate
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'Scholarship Award Letter - Student Details', '1');
SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId+1, @dydtdocumenttypeId+1);
-- SCH_AWARD_LETTER_STUDENT_INFO this is first data provider for document gen
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`,
`sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId+1, 'SCH_AWARD_LETTER_STUDENT_INFO', '1',null,'1', '1', 
'SELECT
    T1.id AS id,
    T3.firstName AS first_name,
    T3.middleName AS middle_name,
    T3.lastName AS last_name,
    T3.code AS student_id,
    T8.externalSysRefOne AS external_ref_no,
    T3.emailId AS primary_email_id,
    T7.displayName AS academy_location,
    CURDATE() AS issue_date,
    T9.salutationName AS salutation,
    T6.scholarshipCode AS scholarship_id,
    T6.scholarshipName AS scholarship_name,
    T10.accountingYear AS accounting_year,
    T12.itemValue AS internal_administration,
    T1.amount AS amount,
    T11.sponsorName AS financing_institution,
    CONCAT(T4.programCode,"/",T4.programName) AS program_code_name,
	T7.logoUrl AS img_academy_location_logo,
	T7.headerUrl AS img_header_url,
	T7.footerUrl AS img_footer_url
FROM
    scholarship_nominate_or_award T1
        LEFT OUTER JOIN
    students T2 ON T1.studentId = T2.userId    
        LEFT OUTER JOIN
    users T3 ON T2.userId = T3.id
        LEFT OUTER JOIN  
    programs T4 ON T1.programId = T4.id
       LEFT OUTER JOIN
    batches T5 ON T1.batchId = T5.id
       LEFT OUTER JOIN
    scholarship T6 ON T6.id = T1.scholarshipId
      LEFT OUTER JOIN
    academy_location T7 ON T7.id=T4.academyLocationId
      LEFT OUTER JOIN 
    persons T8 ON T2.personId = T8.id
      LEFT OUTER JOIN 
    salutations T9 ON T8.salutationId = T9.id
      LEFT OUTER JOIN 
    accounting_year T10 ON T1.accountingYearId = T10.id
      LEFT OUTER JOIN
    sponsors T11 ON T6.financingInstitutionId = T11.id
      LEFT OUTER JOIN
    internal_administrator T12 ON T6.internalFundAdministratorId = T12.id', 'PRM_SCHOLARSHIP_AWARD_LETTER_STUDENT_ID',
    'first_name,middle_name,last_name,student_id,external_ref_no,primary_email_id,academy_location,issue_date,salutation,scholarship_id,scholarship_name,
accounting_year,internal_administration,amount,financing_institution,program_code_name,img_academy_location_logo,img_header_url,img_footer_url,',
'where T1.id=PRM_SCHOLARSHIP_AWARD_LETTER_STUDENT_ID', '0');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('first_name', 'First Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('middle_name', 'Middle Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('last_name', 'Last Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('student_id', 'Student ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('external_ref_no', 'External Ref No.',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('primary_email_id', 'Primary Email ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('academy_location', 'Academy Location',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('issue_date', 'Issue Date',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('salutation', 'Salutation',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('scholarship_id', 'Scholarship ID',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('scholarship_name', 'Scholarship Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('accounting_year', 'Accounting Year',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('internal_administration', 'Internal Administration',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('amount', 'Amount',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('financing_institution', 'Financing Institution',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('program_code_name', 'Program Code/Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_academy_location_logo', 'Academy location logo',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_header_url', 'Header URL',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('img_footer_url', 'Footer URL',@dydtdatalinitemId+1);

SET @dydtTemplateconfId=(SELECT MAX(id) FROM `dydt_template_conf`);
INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`,`templateContent`)
VALUES (@dydtTemplateconfId+1, @dydtdocumenttypeId+1, 'Scholarship Award Letter - Student', 'HTMLTEMPLATE', '0','');

END IF;

END IF;
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20241106104417__Insert_SchAwardLetterStudentDocSupport() $$
DROP PROCEDURE IF EXISTS V20241106104417__Insert_SchAwardLetterStudentDocSupport $$
DELIMITER ;