DELIMITER $$
DROP PROCEDURE IF EXISTS V20241126164244__Create_progressionPanelCourseModeration $$
CREATE PROCEDURE V20241126164244__Create_progressionPanelCourseModeration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='progression_panel_course_moderation')) THEN 
CREATE TABLE `progression_panel_course_moderation` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT NULL,
  `progresssionPanelDecisionId` BIGINT NULL,
  `courseVariantId` BIGINT NULL,
  `moderate` BIGINT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_ProgressionPanel_admission_idx` (`admissionId` ASC) ,
  INDEX `fk_Progression_progresssionPanelDecision_idx` (`progresssionPanelDecisionId` ASC) ,
  INDEX `fk_Progression_courseVariant_idx` (`courseVariantId` ASC) ,
  CONSTRAINT `fk_ProgressionModeration_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_ProgressionPanel_progresssionPanelDecision`
    FOREIGN KEY (`progresssionPanelDecisionId`)
    REFERENCES `progression_panel_decision_template` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_ProgressionPanel_courseVariant`
    FOREIGN KEY (`courseVariantId`)
    REFERENCES `course_variants` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	FOREIGN KEY (lastUpdatedBy)
	REFERENCES users(id));
END IF; 

END $$
CALL V20241126164244__Create_progressionPanelCourseModeration () $$ 
DROP PROCEDURE IF EXISTS V20241126164244__Create_progressionPanelCourseModeration $$ 
DELIMITER ;