DELIMITER $$
DROP PROCEDURE IF EXISTS V20241216181818__Update_ServiceRequestForEscalateApprover $$
CREATE PROCEDURE V20241216181818__Update_ServiceRequestForEscalateApprover()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='QUICK_COMMENT_FOR_ESCALATED_APPROVAR_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
	 T1.id AS ID,
    T6.firstName AS FIRST_NAME,
    T6.lastName AS LAST_NAME,
    T6.emailId AS EMAIL_ID,
    T2.documentName AS DOCUMENT_NAME,
    T1.comments AS COMMENTS,
    T3.requestId AS SERVICE_REQUEST_NO,
    T8.code AS STUDENT_NO,
    T11.programName AS PROGRAM,
    T7.batchName AS BATCH,
    T10.academyName AS ACADEMY_NAME,
    T10.locationName AS LOCATION_NAME,
    T10.displayName AS ACADEMY_NAME_LOCATION,
    (CASE
        WHEN
            T10.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T10.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T10.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T10.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL
FROM 
    quick_comment T1
LEFT OUTER JOIN 
    documents T2 ON T1.id = T2.id
LEFT OUTER JOIN
    service_requests T3 ON T1.serviceRequestId = T3.id
LEFT OUTER JOIN
    service_request_settings T9 ON T3.serviceRequestSettingId = T9.id
LEFT OUTER JOIN
    academy_location T10 ON T9.academyLocationId = T10.id
LEFT OUTER JOIN
    programs T11 ON T3.currentProgram = T11.id
LEFT OUTER JOIN
    batches T7 ON T3.batchId = T7.id
LEFT OUTER JOIN
    approval_details T4 on T3.id = T4.serviceRequestId
LEFT OUTER JOIN
    staffs T5 on T4.escalatedApproverUserId = T5.userId
LEFT OUTER JOIN
    users T6 on T6.id = T5.userId
LEFT OUTER JOIN
    users T8 ON T3.requester = T8.id
LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE 
     T1.id IN (namedParams)" ,

`jsonString`=' {
     "id": 1,
     "searchResultViewColumns": [
         {
            "id": 1,
            "value": "documentName",
            "resultKey": "DOCUMENT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },        
        {
            "id": 2,
            "value": "comments",
            "resultKey": "COMMENTS",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },       
        {
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "requestId",
            "resultKey": "SERVICE_REQUEST_NO",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "code",
            "resultKey": "STUDENT_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchName",
            "resultKey": "BATCH",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 13
        }
    ]
 }
' WHERE `dataProviderId`=@dtproviderId; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20241216181818__Update_ServiceRequestForEscalateApprover () $$
DROP PROCEDURE IF EXISTS V20241216181818__Update_ServiceRequestForEscalateApprover $$
DELIMITER ;