DELIMITER $$
DROP PROCEDURE IF EXISTS V20241224115642__Create_PayLaterApplicantParentVelocity $$
CREATE PROCEDURE V20241224115642__Create_PayLaterApplicantParentVelocity()
BEGIN

IF NOT EXISTS ((SELECT * FROM msg_category WHERE `code`='PAY_LATER_APPLICANT_PARENT_VELOCITY')) THEN 
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'PAY_LATER_APPLICANT_PARENT_VELOCITY');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='PAY_LATER_APPLICANT_PARENT_VELOCITY');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'PAY_LATER_APPLICANT_PARENT_VELOCITY', 'Pay Later Applicant Parent Velocity', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Pay Later Applicant Parent Velocity'); 

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);
 

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PAY_LATER_APPLICANT_FATHER_VELOCITY_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PAY_LATER_APPLICANT_MOTHER_VELOCITY_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PAY_LATER_APPLICANT_FATHER_VELOCITY_RCPNT', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'PAY_LATER_APPLICANT_MOTHER_VELOCITY_RCPNT', 'SQL');


SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_FATHER_VELOCITY_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'PAY_LATER_APPLICANT_FATHER_VELOCITY_RCPNT');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'PAY_LATER_APPLICANT_MOTHER_VELOCITY_RCPNT');


-- The under sql code gives for the user distribution list ,this information can be fetched

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_FATHER_VELOCITY_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PAY_LATER_APPLICANT_FATHER_VELOCITY_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_FATHER_VELOCITY_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT 
    T3.id AS USER_ID
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
WHERE
    T3.id IN (namedParams)
        AND T5.relationship = 'FATHER' AND T3.currentStatus='DIRECT_SUBMISSION_TOKEN_GENERATED' AND T3.applicationCreationSource='ONLINE'",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT 
    T3.id AS USER_ID
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
WHERE
    T3.id IN (namedParams)
        AND T5.relationship = 'MOTHER' AND T3.currentStatus='DIRECT_SUBMISSION_TOKEN_GENERATED' AND T3.applicationCreationSource='ONLINE'",NULL);

-- Below query gives the recepient information like firstName,lastName and other details for the distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_FATHER_VELOCITY_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT 
		T3.id AS ID,
		T6.`firstName` AS FIRST_NAME,
		T6.`lastName` AS LAST_NAME,
		T6.`printName` AS PRINT_NAME,
		T6.`emailId` AS EMAIL_ID,
		T6.`mobileNumber` AS MOBILE_NO,
		T6.`mobileCountryCode` AS MOBILE_CODE,
        T4.`firstName` AS APPLICANT_FIRSTNAME,
		T4.`lastName` AS APPLICANT_LASTNAME,
		T3.`code` AS APPLICATION_CODE,
		T8.displayName AS ACADEMY_NAME_LOCATION,
		T8.academyName AS ACADEMY_NAME,
		T11.programNameToBePrint AS PROGRAM_NAME,
		T12.batchName AS INTAKE,
		(( select
			distinct sum(feestagehe7_.feeAmount) 
		from
			fee_plan this_ 
		left outer join
			currency currency2_ 
				on this_.currencyId=currency2_.id 
		left outer join
			fee_plan_acad_locations feeplanaca1_ 
				on this_.id=feeplanaca1_.feePlanId 
		left outer join
			prog_batch_seat_config programbat3_ 
				on feeplanaca1_.progBatchSeatConfigId=programbat3_.id 
		left outer join
			fee_plan_rules feeplanrul4_ 
				on this_.id=feeplanrul4_.feePlanId 
		left outer join
			fee_plan_rule_stage feeplanrul5_ 
				on feeplanrul4_.id=feeplanrul5_.feePlanRuleId 
		left outer join
			fee_stage_master feeplansta6_ 
				on feeplanrul5_.stageId=feeplansta6_.id 
		left outer join
			fee_stage_head_config feestagehe7_ 
				on feeplanrul5_.id=feestagehe7_.feePlanRuleStageId 
		 left outer join
		 application_program ap 
				on ap.progBatchSeatConfigId=programbat3_.id
		  left outer join
		  application app
			on app.id=ap.applicationId
		where
			this_.feePlanStatus='ACTIVE' 
			and feeplanrul4_.feeSpecificLinkType='NOT_APPLICABLE'
			and app.id=namedParams 
			and feeplansta6_.stageName in ('Application submission') 
		group by
			feeplanrul5_.id)) as TOTAL_AMOUNT,
			(select
			distinct currency2_.currencyCode
		from
			fee_plan this_ 
		left outer join
			currency currency2_ 
				on this_.currencyId=currency2_.id 
		left outer join
			fee_plan_acad_locations feeplanaca1_ 
				on this_.id=feeplanaca1_.feePlanId 
		left outer join
			prog_batch_seat_config programbat3_ 
				on feeplanaca1_.progBatchSeatConfigId=programbat3_.id 
		left outer join
			fee_plan_rules feeplanrul4_ 
				on this_.id=feeplanrul4_.feePlanId 
		left outer join
			fee_plan_rule_stage feeplanrul5_ 
				on feeplanrul4_.id=feeplanrul5_.feePlanRuleId 
		left outer join
			fee_stage_master feeplansta6_ 
				on feeplanrul5_.stageId=feeplansta6_.id 
		left outer join
			fee_stage_head_config feestagehe7_ 
				on feeplanrul5_.id=feestagehe7_.feePlanRuleStageId 
		 left outer join
		 application_program ap 
				on ap.progBatchSeatConfigId=programbat3_.id
		  left outer join
		  application app
			on app.id=ap.applicationId
		where
			this_.feePlanStatus='ACTIVE' 
			and feeplanrul4_.feeSpecificLinkType='NOT_APPLICABLE'
			and app.id=namedParams 
			and feeplansta6_.stageName in ('Application submission') 
		group by
			feeplanrul5_.id) as CURRENCY_CODE
		
	FROM
		external_users T1
			LEFT JOIN
		external_user_association T2 ON T2.externalUserId = T1.id
			LEFT JOIN
		application T3 ON T3.id = T2.applicationId
			LEFT JOIN
		applicant_person T4 ON T4.id = T3.applicantPersonId
			LEFT OUTER JOIN
		applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
			LEFT JOIN
		applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
			LEFT JOIN
		application_program T7 ON T7.applicationId = T3.id
			LEFT OUTER JOIN
            prog_batch_seat_config T14 on T14.id=T7.progBatchSeatConfigId
            LEFT OUTER JOIN
			programs T11 on T11.id=T7.programId
			INNER JOIN 
			batches T12 on T12.id=T14.programBatchId
			LEFT JOIN
		academy_location T8 ON T8.id = T7.academyLocationId
	WHERE
		T3.id IN (namedParams) AND T5.relationship = 'FATHER' AND T3.currentStatus='DIRECT_SUBMISSION_TOKEN_GENERATED' AND T3.applicationCreationSource='ONLINE'",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        } ,
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 9,
            "value": "printName",
            "resultKey": "APPLICANT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id":10,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id":11,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id":12,
            "value": "intake",
            "resultKey": "INTAKE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id":12,
            "value": "currency",
            "resultKey": "CURRENCY_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id":13,
            "value": "fees",
            "resultKey": "TOTAL_AMOUNT",
            "displayCode": "",
            "displayOrder": 9
        }
		
    ]
}');

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT 
		T3.id AS ID,
		T6.`firstName` AS FIRST_NAME,
		T6.`lastName` AS LAST_NAME,
		T6.`printName` AS PRINT_NAME,
		T6.`emailId` AS EMAIL_ID,
		T6.`mobileNumber` AS MOBILE_NO,
		T6.`mobileCountryCode` AS MOBILE_CODE,
        T4.`firstName` AS APPLICANT_FIRSTNAME,
		T4.`lastName` AS APPLICANT_LASTNAME,
		T3.`code` AS APPLICATION_CODE,
		T8.displayName AS ACADEMY_NAME_LOCATION,
		T8.academyName AS ACADEMY_NAME,
		T11.programNameToBePrint AS PROGRAM_NAME,
		T12.batchName AS INTAKE,
		(( select
			distinct sum(feestagehe7_.feeAmount) 
		from
			fee_plan this_ 
		left outer join
			currency currency2_ 
				on this_.currencyId=currency2_.id 
		left outer join
			fee_plan_acad_locations feeplanaca1_ 
				on this_.id=feeplanaca1_.feePlanId 
		left outer join
			prog_batch_seat_config programbat3_ 
				on feeplanaca1_.progBatchSeatConfigId=programbat3_.id 
		left outer join
			fee_plan_rules feeplanrul4_ 
				on this_.id=feeplanrul4_.feePlanId 
		left outer join
			fee_plan_rule_stage feeplanrul5_ 
				on feeplanrul4_.id=feeplanrul5_.feePlanRuleId 
		left outer join
			fee_stage_master feeplansta6_ 
				on feeplanrul5_.stageId=feeplansta6_.id 
		left outer join
			fee_stage_head_config feestagehe7_ 
				on feeplanrul5_.id=feestagehe7_.feePlanRuleStageId 
		 left outer join
		 application_program ap 
				on ap.progBatchSeatConfigId=programbat3_.id
		  left outer join
		  application app
			on app.id=ap.applicationId
		where
			this_.feePlanStatus='ACTIVE' 
			and feeplanrul4_.feeSpecificLinkType='NOT_APPLICABLE'
			and app.id=namedParams 
			and feeplansta6_.stageName in ('Application submission') 
		group by
			feeplanrul5_.id)) as TOTAL_AMOUNT,
			(select
			distinct currency2_.currencyCode
		from
			fee_plan this_ 
		left outer join
			currency currency2_ 
				on this_.currencyId=currency2_.id 
		left outer join
			fee_plan_acad_locations feeplanaca1_ 
				on this_.id=feeplanaca1_.feePlanId 
		left outer join
			prog_batch_seat_config programbat3_ 
				on feeplanaca1_.progBatchSeatConfigId=programbat3_.id 
		left outer join
			fee_plan_rules feeplanrul4_ 
				on this_.id=feeplanrul4_.feePlanId 
		left outer join
			fee_plan_rule_stage feeplanrul5_ 
				on feeplanrul4_.id=feeplanrul5_.feePlanRuleId 
		left outer join
			fee_stage_master feeplansta6_ 
				on feeplanrul5_.stageId=feeplansta6_.id 
		left outer join
			fee_stage_head_config feestagehe7_ 
				on feeplanrul5_.id=feestagehe7_.feePlanRuleStageId 
		 left outer join
		 application_program ap 
				on ap.progBatchSeatConfigId=programbat3_.id
		  left outer join
		  application app
			on app.id=ap.applicationId
		where
			this_.feePlanStatus='ACTIVE' 
			and feeplanrul4_.feeSpecificLinkType='NOT_APPLICABLE'
			and app.id=namedParams 
			and feeplansta6_.stageName in ('Application submission') 
		group by
			feeplanrul5_.id) as CURRENCY_CODE
		
	FROM
		external_users T1
			LEFT JOIN
		external_user_association T2 ON T2.externalUserId = T1.id
			LEFT JOIN
		application T3 ON T3.id = T2.applicationId
			LEFT JOIN
		applicant_person T4 ON T4.id = T3.applicantPersonId
			LEFT OUTER JOIN
		applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
			LEFT JOIN
		applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
			LEFT JOIN
		application_program T7 ON T7.applicationId = T3.id
			LEFT OUTER JOIN
            prog_batch_seat_config T14 on T14.id=T7.progBatchSeatConfigId
            LEFT OUTER JOIN
			programs T11 on T11.id=T7.programId
			INNER JOIN 
			batches T12 on T12.id=T14.programBatchId
			LEFT JOIN
		academy_location T8 ON T8.id = T7.academyLocationId
	WHERE
		T3.id IN (namedParams) AND T5.relationship = 'MOTHER' AND T3.currentStatus='DIRECT_SUBMISSION_TOKEN_GENERATED' AND T3.applicationCreationSource='ONLINE'",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        } ,
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 9,
            "value": "printName",
            "resultKey": "APPLICANT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 7
        },
		{
            "id":10,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id":11,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id":12,
            "value": "intake",
            "resultKey": "INTAKE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id":12,
            "value": "currency",
            "resultKey": "CURRENCY_CODE",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id":13,
            "value": "fees",
            "resultKey": "TOTAL_AMOUNT",
            "displayCode": "",
            "displayOrder": 9
        }
		
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='PAY_LATER_APPLICANT_FATHER_VELOCITY_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='PAY_LATER_APPLICANT_PARENT_VELOCITY');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='PAY_LATER_APPLICANT_PARENT_VELOCITY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PAY_LATER_APPLICANT_FATHER_VELOCITY_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Pay Later Applicant Father Velocity',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,1,NULL,NULL,'Pay Later Applicant Father Velocity',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Submitted — Payment Pending','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong><br/><br/>Dear <strong>$recipientData[&quot;PRINT_NAME&quot;]</strong></span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thankyou-we have received your application for  <strong>$recipientData[&quot;APPLICANT_FIRSTNAME&quot;]</strong> for <strong>$recipientData[&quot;PROGRAM_NAME&quot;]</strong> for <strong>$recipientData[&quot;INTAKE&quot;]</strong>
<br />
<br />
Your Application ID, your reference number for this application, is <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong>
<br />
<br />
Please note in order for us to process your application, the non-refundable application fee of <strong>$recipientData[&quot;TOTAL_AMOUNT&quot;]</strong> is required. Please return to the Online Application Forms and click the <b>Pending Application</b> option on the screen and enter your <b>Application ID</b> and <b>Email Address</b> and click the <b>Fetch Details</b> button. Please double check your details and then click the <b>Submit</b> button, you will then be able to click the <b>Pay Now</b> option to make payment for your application.<br/><br/>
Alternatively, should you wish to pay via EFT, please contact us directly to arrange for payment to be made. <br/><br/>
Once payment has been made, we will be in touch to complete the application process with you. <br/><br/>
Please ignore this email if you have already paid.<br /><br />
Kind regards, <br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>		
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='PAY_LATER_APPLICANT_PARENT_VELOCITY');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='PAY_LATER_APPLICANT_PARENT_VELOCITY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='PAY_LATER_APPLICANT_MOTHER_VELOCITY_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Pay Later Applicant Mother Velocity',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,1,NULL,NULL,'Pay Later Applicant Mother Velocity',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Submitted — Payment Pending','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong><br/><br/>Dear <strong>$recipientData[&quot;PRINT_NAME&quot;]</strong></span></span></p>

<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thankyou-we have received your application for  <strong>$recipientData[&quot;APPLICANT_FIRSTNAME&quot;]</strong> for <strong>$recipientData[&quot;PROGRAM_NAME&quot;]</strong> for <strong>$recipientData[&quot;INTAKE&quot;]</strong>
<br />
<br />
Your Application ID, your reference number for this application, is <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong>
<br />
<br />
Please note in order for us to process your application, the non-refundable application fee of <strong>$recipientData[&quot;TOTAL_AMOUNT&quot;]</strong> is required. Please return to the Online Application Forms and click the <b>Pending Application</b> option on the screen and enter your <b>Application ID</b> and <b>Email Address</b> and click the <b>Fetch Details</b> button. Please double check your details and then click the <b>Submit</b> button, you will then be able to click the <b>Pay Now</b> option to make payment for your application.<br/><br/>
Alternatively, should you wish to pay via EFT, please contact us directly to arrange for payment to be made. <br/><br/>
Once payment has been made, we will be in touch to complete the application process with you. <br/><br/>
Please ignore this email if you have already paid.<br /><br />
Kind regards, <br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>		
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');


END IF; 
END $$
CALL V20241224115642__Create_PayLaterApplicantParentVelocity () $$ 
DROP PROCEDURE IF EXISTS V20241224115642__Create_PayLaterApplicantParentVelocity $$ 
DELIMITER ;

