DELIMITER $$
DROP PROCEDURE IF EXISTS V20241230110726__Create_Tables_For_Inspirasi_usages_report $$
CREATE PROCEDURE V20241230110726__Create_Tables_For_Inspirasi_usages_report()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='ins_daily_usage_report_from_email_conf')) THEN 
CREATE TABLE `ins_daily_usage_report_from_email_conf` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userName` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `senderEmailAddress` varchar(255) DEFAULT NULL,
  `clientImageUrl` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `port` varchar(255) DEFAULT NULL,
  `isActive` bit(1) DEFAULT NULL,
  `isDefault` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `domainName` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `ins_daily_usage_report_from_email_conf_ibfk_1_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='monthly_report_master_Ins')) THEN 
CREATE TABLE `monthly_report_master_Ins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `paramName` varchar(255) NOT NULL,
  `query` longtext,
  `groupings` varchar(255) DEFAULT NULL,
  `paramFullName` varchar(255) DEFAULT NULL,
  `sequences` bigint DEFAULT NULL,
  `status` bit(1) DEFAULT NULL,
  `summary_display` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='monthly_report_master_osm_ins')) THEN 
CREATE TABLE `monthly_report_master_osm_ins` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gridDisplayColumn` varchar(255) NOT NULL,
  `summary_display_column` varchar(255) DEFAULT NULL,
  `status` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='monthly_report_count_inspirasi')) THEN 
CREATE TABLE `monthly_report_count_inspirasi` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `monthlyReportMaster` bigint NOT NULL,
  `monthlyCount` varchar(200) DEFAULT '0',
  `reportDate` datetime DEFAULT NULL,
  `diffrence` double DEFAULT '0',
  `percent` double DEFAULT '0',
  `status` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='monthly_login_history_report_inspirasi')) THEN 
CREATE TABLE `monthly_login_history_report_inspirasi` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reportDate` date DEFAULT NULL,
  `loginCount` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='usage_report_email_configuration_ins')) THEN 
CREATE TABLE `usage_report_email_configuration_ins` (
  	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`codeId` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
);
END IF; 



END $$
CALL V20241230110726__Create_Tables_For_Inspirasi_usages_report () $$ 
DROP PROCEDURE IF EXISTS V20241230110726__Create_Tables_For_Inspirasi_usages_report $$ 
DELIMITER ;