DELIMITER $$
DROP PROCEDURE IF EXISTS V20250218141638__Create_debarment_academy_location $$
CREATE PROCEDURE V20250218141638__Create_debarment_academy_location()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='debarment_academy_location')) THEN 
CREATE TABLE `debarment_academy_location` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `debarmentReasonId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `FK_debarment_reaon_idx` (`debarmentReasonId` ASC) ,
  INDEX `FK_debarment_reason_academy_location_idx` (`academyLocationId` ASC) ,
  INDEX `FK_debarement_lastUpdatedBy_idx` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `FK_debarment_reason`
    FOREIGN KEY (`debarmentReasonId`)
    REFERENCES `debarment_reasons` (`id`),
  CONSTRAINT `FK_debarment_reason_academy_location`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`),
  CONSTRAINT `FK_debarement_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20250218141638__Create_debarment_academy_location () $$ 
DROP PROCEDURE IF EXISTS V20250218141638__Create_debarment_academy_location $$ 
DELIMITER ;