DELIMITER $$
DROP PROCEDURE IF EXISTS V20250320105354__Insert_AddDataProviderToOfferLetter $$
CREATE PROCEDURE V20250320105354__Insert_AddDataProviderToOfferLetter()
BEGIN

IF EXISTS ((SELECT * FROM `dydt_data_provider` WHERE providerName='OFFER_LETTER_INFO')) THEN 
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` WHERE providerName='OFFER_LETTER_INFO');

IF NOT EXISTS ((SELECT * FROM dydt_data_line_item WHERE dataSourceCode='OFFER_LETTER_INTERVIEWER_INFO' AND dataProviderId=@dydtdataproviderId)) THEN 
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'OFFER_LETTER_INTERVIEWER_INFO', '17',null, '1', '0', 
"SELECT ap.decisionByInterviewer AS DECISION_BY_INTERVIEWER ,ap.commentsByInterviewer AS COMMENTS_BY_INTERVIEWER FROM application a LEFT JOIN  applicant_person ap ON a.applicantPersonId = ap.id",
'PRM_APPLICATION_ID','DECISION_BY_INTERVIEWER,COMMENTS_BY_INTERVIEWER','WHERE a.id=PRM_APPLICATION_ID','0');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('DECISION_BY_INTERVIEWER', 'Decision By Interviewer',@dydtdatalinitemId+1);

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES ('COMMENTS_BY_INTERVIEWER', 'Comments By Interviewer',@dydtdatalinitemId+1);

END IF; 

END IF; 

END $$
CALL V20250320105354__Insert_AddDataProviderToOfferLetter() $$
DROP PROCEDURE IF EXISTS V20250320105354__Insert_AddDataProviderToOfferLetter $$
DELIMITER ;