DELIMITER $$
DROP PROCEDURE IF EXISTS V20250320112711__Alter_xeroInvMapping $$
CREATE PROCEDURE V20250320112711__Alter_xeroInvMapping()
BEGIN
-- Drop foreign key if it exists
IF EXISTS (SELECT * FROM information_schema.KEY_COLUMN_USAGE 
           WHERE TABLE_SCHEMA = DATABASE() 
           AND TABLE_NAME = 'xero_invoice_mapping' 
           AND CONSTRAINT_NAME = 'fk_xero_invoice_mapping_academiaUserId') 
THEN 
    ALTER TABLE  `xero_invoice_mapping` 
    DROP FOREIGN KEY `fk_xero_invoice_mapping_academiaUserId`;
END IF;

-- Add column if it does not exist
IF NOT EXISTS (SELECT * FROM information_schema.COLUMNS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_invoice_mapping' 
               AND COLUMN_NAME = 'academiaSponsorId') 
THEN
    ALTER TABLE  `xero_invoice_mapping` 
    ADD COLUMN `academiaSponsorId` BIGINT NULL AFTER `academiaUserId`;
END IF;

-- Modify column if it exists
IF EXISTS (SELECT * FROM information_schema.COLUMNS 
           WHERE TABLE_SCHEMA = DATABASE() 
           AND TABLE_NAME = 'xero_invoice_mapping' 
           AND COLUMN_NAME = 'academiaUserId') 
THEN
    ALTER TABLE  `xero_invoice_mapping` 
    CHANGE COLUMN `academiaUserId` `academiaUserId` BIGINT NULL;
END IF;

-- Add index if it does not exist
IF NOT EXISTS (SELECT * FROM information_schema.STATISTICS 
               WHERE TABLE_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_invoice_mapping' 
               AND INDEX_NAME = 'fk_xero_invoice_mapping_academiaSponsorId_idx') 
THEN
    ALTER TABLE  `xero_invoice_mapping` 
    ADD INDEX `fk_xero_invoice_mapping_academiaSponsorId_idx` (`academiaSponsorId` ASC);
END IF;

-- Add foreign key constraints if they do not exist
IF NOT EXISTS (SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS 
               WHERE CONSTRAINT_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_invoice_mapping' 
               AND CONSTRAINT_NAME = 'fk_xero_invoice_mapping_academiaUserId') 
THEN
    ALTER TABLE  `xero_invoice_mapping` 
    ADD CONSTRAINT `fk_xero_invoice_mapping_academiaUserId`
      FOREIGN KEY (`academiaUserId`)
      REFERENCES  `users` (`id`);
END IF;

IF NOT EXISTS (SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS 
               WHERE CONSTRAINT_SCHEMA = DATABASE() 
               AND TABLE_NAME = 'xero_invoice_mapping' 
               AND CONSTRAINT_NAME = 'fk_xero_invoice_mapping_academiaSponsorId') 
THEN
    ALTER TABLE  `xero_invoice_mapping` 
    ADD CONSTRAINT `fk_xero_invoice_mapping_academiaSponsorId`
      FOREIGN KEY (`academiaSponsorId`)
      REFERENCES  `sponsors` (`id`);
END IF;
END $$
CALL V20250320112711__Alter_xeroInvMapping() $$
DROP PROCEDURE IF EXISTS V20250320112711__Alter_xeroInvMapping $$
DELIMITER ;