DELIMITER $$
DROP PROCEDURE IF EXISTS V20250414154940__Create_course_cesm_roles $$
CREATE PROCEDURE V20250414154940__Create_course_cesm_roles()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_cesm_roles')) THEN 
CREATE TABLE `course_cesm_roles` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseCESMId` BIGINT(20) NOT NULL,
  `roleId` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `FK_courseCesm_idx` (`courseCESMId` ASC),
  INDEX `FK_courseCesmRoles_idx` (`roleId` ASC),
  CONSTRAINT `FK_courseCesm`
    FOREIGN KEY (`courseCESMId`)
    REFERENCES `course_cesm_code` (`id`),
  CONSTRAINT `FK_courseCesmRoles`
    FOREIGN KEY (`roleId`)
    REFERENCES `roles` (`id`));
END IF; 

END $$
CALL V20250414154940__Create_course_cesm_roles () $$ 
DROP PROCEDURE IF EXISTS V20250414154940__Create_course_cesm_roles $$ 
DELIMITER ;