DELIMITER $$
DROP PROCEDURE IF EXISTS V20250414170038__Create_batchStudentClassification $$
CREATE PROCEDURE V20250414170038__Create_batchStudentClassification()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND TABLE_NAME = 'batch_student_classification')) THEN 
CREATE TABLE `batch_student_classification` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `batchId` bigint NOT NULL,
  `studentClassificationId` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_batch_student_classification_batchId` (`batchId`),
  KEY `fk_batch_student_classification_studentClassificationId` (`studentClassificationId`),
  CONSTRAINT `fk_batch_student_classification_studentClassificationId` FOREIGN KEY (`studentClassificationId`) REFERENCES `student_classification_csm` (`id`),
  CONSTRAINT `fk_batch_student_classification_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`)
) ;
END IF; 

END $$
CALL V20250414170038__Create_batchStudentClassification () $$ 
DROP PROCEDURE IF EXISTS V20250414170038__Create_batchStudentClassification $$ 
DELIMITER ;