DELIMITER $$
DROP PROCEDURE IF EXISTS fatchServiceTypeInvToBePushInXero $$
CREATE PROCEDURE fatchServiceTypeInvToBePushInXero(jobLastRunTimestamp timestamp)
BEGIN
SELECT 
    FUNC_INC_VAR_SESSION_REC() AS id,
    xUser.xeroContactId AS xeroContactId,
	xUser.academiaUserId as academiaUserId,
    null as academiaSponsorId,
    bill.totalAmount AS unitAmount,
    bill.billNo AS invoiceNumber,
	bill.id AS billHeaderId,
    bfprs.billableAmount AS lineAmount,
    heads.feeHeadName AS feeHeadName,
    curr.currencyCode AS currencyCode,
    bill.billingDate AS billingDate,
    bill.dueDate AS dueDate,
    bill.reasonForManualBill AS reason,
    bill.billStatus AS billStatus,
    bill.academyLocationId AS academyLocationId,
    bill.cancellationDate AS cancellationDate,
    bill.cancellationNarration AS cancellationNarration,
    bill.raiseBillCategory AS raiseBillCategory,
    xeroInvMap.id as xeroInvDbId,
    IF(LOCATE('-', heads.feeHeadName) > 0, SUBSTRING_INDEX(heads.feeHeadName, '-', 1), NULL) AS accountCode,
    xeroInvMap.createdDate as createdDate
    
FROM
    xero_user_mapping AS xUser
        JOIN
    bill_header AS bill ON (bill.studentId = xUser.academiaUserId
        AND bill.raiseBillCategory = 'BILL_RECEIVABLE' AND bill.raiseBillType IN ('SERVICE_PROVIDED','SERVICE_RECEIVED'))
        JOIN
	bill_fee_plan_rule_stage as bfprs ON bfprs.billId=bill.id
		JOIN
	fee_stage_head_config as fshc ON bfprs.feeStageHeadConfigId=fshc.id
		JOIN
	fee_heads as heads ON fshc.feeHeadId=heads.id
        JOIN
	prog_batch_seat_config As pbsc on pbsc.id=bill.programBatchSeatConfigId
		join 
	batches as batch on batch.id=pbsc.programBatchId
       join 
	programs as prog on prog.id= batch.programId
        LEFT JOIN
    currency AS curr ON bill.currencyId = curr.id
        LEFT JOIN
    xero_invoice_mapping AS xeroInvMap ON (xeroInvMap.academiaBillHeaderId = bill.id and bill.academyLocationId =xeroInvMap.academyLocationId)
		LEFT JOIN
    drop_down AS drp ON (drp.type = 'XeroRetriggerMaxAttemptDays')
WHERE
    bill.totalAmount IS NOT NULL AND (xeroInvMap.id IS NULL  OR (xeroInvMap.error IS NOT NULL
        AND (xeroInvMap.createdDate + INTERVAL CAST(drp.value AS SIGNED) DAY)>=CURRENT_DATE)) order by billHeaderId;
END $$ 
DELIMITER ;