DELIMITER $$

DROP PROCEDURE IF EXISTS V20250416121831__Insert_AlumniSSOUser $$

CREATE PROCEDURE V20250416121831__Insert_AlumniSSOUser()
BEGIN
    DECLARE alumniSsoUserId BIGINT;

    -- Check if user with code 'ALUMNI_SSO' already exists
    IF NOT EXISTS (
        SELECT 1 FROM `users` WHERE `code` = 'ALUMNI_SSO'
    ) THEN 
        -- Insert ALUMNI_SSO user
        INSERT INTO `users` (
            `code`, `firstName`, `middleName`, `lastName`, `shortName`, `printName`, `emailId`,
            `calendarId`, `whetherSystemUser`, `password`, `salt`, `ipAddress`, 
            `lockedOn`, `status`, `lockedStatus`, `lockedReason`, `noOfTimesLocked`, 
            `noOfLoginFailed`, `lastLockReleaseDate`, `totalAutoLogout`, `whetherDeleted`, 
            `totalLoginFailed`, `accountingKey`, `userGroupId`, `whetherInternal`, 
            `lastUpdatedBy`, `lastUpdate`, `version`, `whetherPasswordReset`, 
            `inactiveReasonCode`, `temporaryInActive`, `passwordLastUpdated`
        ) VALUES (
            'ALUMNI_SSO', 'ALUMNISSO_FIRST_NAME', 'ALUMNISSO_MIDDLE_NAME', 'ALUMNISSO_LAST_NAME', 
            'ALUMNI_SSO', 'ALUMNI_SSO','alumniuser@gml.com', 1, '\0', 
            'a8c4b282178bfa90b4bc73abfe110a1801e5f85f9ff33efb964ef1343b4211aa',
            '.,\'57;*PSF<K9KDV\'QY@*3EF9.95480', NULL, 
            '2016-01-11 11:25:35', TRUE, '\0', NULL, 0, 0, NULL, NULL, '\0', 
            1, NULL, 2, TRUE, 1, 
            '2016-01-11 12:43:25', 5, '\0', NULL, 0, 
            '2016-01-11 12:43:25'
        );

        -- Declare session variable for social login integration id
        IF EXISTS (
            SELECT * FROM information_schema.tables 
            WHERE table_schema = DATABASE() AND table_name = 'social_login_integration'
        ) THEN 
            -- Get max id + 1
            SELECT IFNULL(MAX(`id`), 0) + 1 INTO @newSocialLoginId FROM `social_login_integration`;

            -- Insert new entry with new ID
            INSERT INTO `social_login_integration` (`id`, `socialLogin`, `lastUpdatedBy`)
            VALUES (@newSocialLoginId, 'Alumni', '1');
        END IF;

        -- Get the ID of the newly inserted ALUMNI_SSO user
        SELECT `id` INTO @alumniSsoUserId FROM `users` WHERE `code` = 'ALUMNI_SSO' LIMIT 1;

        -- Insert into users_social
        INSERT INTO `users_social` (
            `userId`, `socialId`, `lastUpdatedBy`, `lastUpdate`, `socialLoginIntegrationId`
        ) VALUES (
            @alumniSsoUserId, 'alumniuser@gml.com', '1', '2025-03-04 19:33:20', @newSocialLoginId
        );
    END IF;
END $$

-- Call the procedure
CALL V20250416121831__Insert_AlumniSSOUser() $$

-- Drop the procedure after use
DROP PROCEDURE IF EXISTS V20250416121831__Insert_AlumniSSOUser $$

DELIMITER ;
