DELIMITER $$

DROP PROCEDURE IF EXISTS event_covered_data $$
CREATE PROCEDURE event_covered_data(IN evaluationId INT, IN limitCount INT,IN offsetCount INT)BEGIN
DECLARE publishVariable INT;
DECLARE booleanPublishVariable BOOLEAN;
IF(limitCount is not null) THEN
	SELECT
        COUNT(this_.id)
    INTO
        publishVariable
    FROM
        eval_group_hall_ticket this_
    WHERE
        this_.evaluationGroupId = evaluationId
        AND this_.isPublishHallTicket = true;
       
	IF publishVariable > 0 THEN
        SET booleanPublishVariable = TRUE;
    ELSE
        SET booleanPublishVariable = FALSE;
    END IF;
   ELSE 
	SET booleanPublishVariable=FALSE;
END IF;
IF (limitCount is null) THEN

    SELECT
        DISTINCT this_.id AS id,
        evaluation3_.id AS evaluationGroupId,
        program11_.programName AS programName,
        evaluation7_.evaluationPlanNumber AS evaluationPlanNumber,
        groupsched15_.id AS groupScheduleBatchId,
        batch10_.id AS batchId,
        groupsched15_.batchName AS batchName,
        academicte4_.itemValue AS academicTerm,
        course13_.id AS courseId,
        exameventd17_.eventName AS dynamicEventName,
        examcenter2_.centerName AS centerName,
        evaluation3_.examdateTill AS examdateTillDate,
        section8_.sectionCode AS sectionName,
        examcenter2_.centerType AS centerType,
        coursevari12_.courseVariantCode AS courseVariantName,
        evaluation6_.whetherDateTimeApplicable AS whetherDateTimeApplicable,
        groupsched15_.timeFrom AS timeFrom,
        section8_.id AS sectionId,
        evaluation3_.isAutoExamSchedule AS isAutoExamSchedule,
        evaluation5_.id AS evalDetailSeqId,
        batch10_.batchName AS programBatchName,
        period9_.id AS periodId,
        evaluation14_.scheduleDate AS plannedDate,
        evaluation5_.detailSequenceNumber AS detailSequenceNumber,
        examcenter2_.id AS examCenterId,
        evaluation7_.evaluationPlanType AS evaluationPlanType,
        program11_.id AS programId,
        evaluation7_.id AS evaluationPlanNumberId,
        period9_.programPeriodName AS periodName,
        coursevari12_.id AS courseVariantId,
        groupsched15_.timeTo AS timeTo ,
		concat(course13_.courseCode,' / ',course13_.courseName) AS courseCode,
        booleanPublishVariable AS isHallTicketPublish,
        evaluation14_.id AS evaluationGroupScheduleDateId
    FROM
        group_date_batch_center this_ 
    INNER JOIN
        eval_group_center evaluation1_ ON this_.evalGroupSchCenterId = evaluation1_.id 
	INNER JOIN
        prog_batch_period_config period9_ ON evaluation1_.periodId = period9_.id 
    INNER JOIN
        batches batch10_ ON period9_.programBatchId = batch10_.id 
    INNER JOIN
        programs program11_ ON batch10_.programId = program11_.id 
    INNER JOIN
        sections section8_ ON evaluation1_.sectionId = section8_.id 
    INNER JOIN
        course_variants coursevari12_ ON evaluation1_.courseVariantId = coursevari12_.id 
    INNER JOIN
        courses course13_ ON coursevari12_.courseId = course13_.id 
    LEFT OUTER JOIN
        evaluation_type_course evaluation16_ ON coursevari12_.id = evaluation16_.courseVariantId 
            AND (evaluation16_.courseVariantId = coursevari12_.id) 
    INNER JOIN
        evaluation_group evaluation3_ ON evaluation1_.evaluationGroupId = evaluation3_.id 
    LEFT OUTER JOIN
        academic_term academicte4_ ON evaluation3_.academicTermId = academicte4_.id 
    INNER JOIN
        eval_seq_detail evaluation5_ ON evaluation1_.evalSequenceDetailId = evaluation5_.id 
    LEFT OUTER JOIN
        eval_group_sequences evaluation6_ ON evaluation5_.id = evaluation6_.evalSequenceDetailId 
		and evaluation6_.courseVariantId=coursevari12_.id and evaluation6_.periodId=period9_.id
    LEFT OUTER JOIN
        evaluation_plan evaluation7_ ON evaluation6_.evaluationPlanId = evaluation7_.id 
    LEFT OUTER JOIN
        exam_event_detail exameventd17_ ON evaluation5_.id = exameventd17_.eventId 
            AND (evaluation16_.id = exameventd17_.evaluationTypeCourseId) 
    LEFT OUTER JOIN
        exam_center examcenter2_ ON evaluation1_.centerId = examcenter2_.id 
    LEFT OUTER JOIN
        eval_group_sch_date evaluation14_ ON this_.evalGroupSchDateId = evaluation14_.id 
    LEFT OUTER JOIN
        group_schedule_batch groupsched15_ ON this_.evalGroupSchBatchId = groupsched15_.id 
    WHERE
        evaluation3_.id = evaluationId 
    GROUP BY
        this_.id;
ELSE

SELECT
        DISTINCT this_.id AS id,
        evaluation3_.id AS evaluationGroupId,
        program11_.programName AS programName,
        evaluation7_.evaluationPlanNumber AS evaluationPlanNumber,
        groupsched15_.id AS groupScheduleBatchId,
        batch10_.id AS batchId,
        groupsched15_.batchName AS batchName,
        academicte4_.itemValue AS academicTerm,
        course13_.id AS courseId,
        exameventd17_.eventName AS dynamicEventName,
        examcenter2_.centerName AS centerName,
        evaluation3_.examdateTill AS examdateTillDate,
        section8_.sectionCode AS sectionName,
        examcenter2_.centerType AS centerType,
        coursevari12_.courseVariantCode AS courseVariantName,
        evaluation6_.whetherDateTimeApplicable AS whetherDateTimeApplicable,
        groupsched15_.timeFrom AS timeFrom,
        section8_.id AS sectionId,
        evaluation3_.isAutoExamSchedule AS isAutoExamSchedule,
        evaluation5_.id AS evalDetailSeqId,
        batch10_.batchName AS programBatchName,
        period9_.id AS periodId,
        evaluation14_.scheduleDate AS plannedDate,
        evaluation5_.detailSequenceNumber AS detailSequenceNumber,
        examcenter2_.id AS examCenterId,
        evaluation7_.evaluationPlanType AS evaluationPlanType,
        program11_.id AS programId,
        evaluation7_.id AS evaluationPlanNumberId,
        period9_.programPeriodName AS periodName,
        coursevari12_.id AS courseVariantId,
        groupsched15_.timeTo AS timeTo ,
        concat(course13_.courseCode,' / ',course13_.courseName) AS courseCode,
        booleanPublishVariable AS isHallTicketPublish,
        evaluation14_.id AS evaluationGroupScheduleDateId
    FROM
        group_date_batch_center this_ 
    INNER JOIN
        eval_group_center evaluation1_ ON this_.evalGroupSchCenterId = evaluation1_.id 
	INNER JOIN
        prog_batch_period_config period9_ ON evaluation1_.periodId = period9_.id 
    INNER JOIN
        batches batch10_ ON period9_.programBatchId = batch10_.id 
    INNER JOIN
        programs program11_ ON batch10_.programId = program11_.id 
    INNER JOIN
        sections section8_ ON evaluation1_.sectionId = section8_.id 
    INNER JOIN
        course_variants coursevari12_ ON evaluation1_.courseVariantId = coursevari12_.id 
    INNER JOIN
        courses course13_ ON coursevari12_.courseId = course13_.id 
    LEFT OUTER JOIN
        evaluation_type_course evaluation16_ ON coursevari12_.id = evaluation16_.courseVariantId 
            AND (evaluation16_.courseVariantId = coursevari12_.id) 
    INNER JOIN
        evaluation_group evaluation3_ ON evaluation1_.evaluationGroupId = evaluation3_.id 
    LEFT OUTER JOIN
        academic_term academicte4_ ON evaluation3_.academicTermId = academicte4_.id 
    INNER JOIN
        eval_seq_detail evaluation5_ ON evaluation1_.evalSequenceDetailId = evaluation5_.id 
    LEFT OUTER JOIN
        eval_group_sequences evaluation6_ ON evaluation5_.id = evaluation6_.evalSequenceDetailId 
		and evaluation6_.courseVariantId=coursevari12_.id and evaluation6_.periodId=period9_.id
    LEFT OUTER JOIN
        evaluation_plan evaluation7_ ON evaluation6_.evaluationPlanId = evaluation7_.id 
    LEFT OUTER JOIN
        exam_event_detail exameventd17_ ON evaluation5_.id = exameventd17_.eventId 
            AND (evaluation16_.id = exameventd17_.evaluationTypeCourseId) 
    LEFT OUTER JOIN
        exam_center examcenter2_ ON evaluation1_.centerId = examcenter2_.id 
    LEFT OUTER JOIN
        eval_group_sch_date evaluation14_ ON this_.evalGroupSchDateId = evaluation14_.id 
    LEFT OUTER JOIN
        group_schedule_batch groupsched15_ ON this_.evalGroupSchBatchId = groupsched15_.id 
    WHERE
        evaluation3_.id = evaluationId 
    GROUP BY
        this_.id 
    ORDER BY
        CONCAT(course13_.courseCode, ' / ', course13_.courseName) ASC,
        coursevari12_.courseVariantCode ASC,
        section8_.sectionCode ASC,
        evaluation7_.evaluationPlanNumber ASC,
        examcenter2_.centerName ASC,
        evaluation14_.scheduleDate ASC,
        groupsched15_.batchName ASC limit limitCount offset offsetCount;

END IF; 

END $$

DELIMITER ;