DELIMITER $$
DROP PROCEDURE IF EXISTS V20250516184841__Insert_CurriculumAccrediationCSM $$
CREATE PROCEDURE V20250516184841__Insert_CurriculumAccrediationCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='curriculum_accrediation')) THEN 
CREATE TABLE `curriculum_accrediation` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- CSM Data --

SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'CURRICULUM_ACCREDITATION')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'curriculum_accrediation','CURRICULUM_ACCREDITATION','Program & Courses','COMMON_MASTER',0,0,NULL,1,now());

IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterMaxId+1 and fieldLabel='ITEM_CODE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('code','ITEM_CODE',@standardMasterMaxId+1,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

IF NOT EXISTS ((select * from standard_master_items where standardMasterId = @standardMasterMaxId+1 and fieldLabel='ITEM_VALUE')) THEN
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('value','ITEM_VALUE',@standardMasterMaxId+1,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,1,now());
END IF;

END IF;

-- TRANSLATION --

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'CURRICULUM_ACCREDITATION')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'CURRICULUM_ACCREDITATION', '	', 'Curriculum Accrediation','Kurrikulum Akkreditasie','Công nhận chương trình giảng dạy',now(),1);
END IF;

END IF; 

END $$
CALL V20250516184841__Insert_CurriculumAccrediationCSM() $$
DROP PROCEDURE IF EXISTS V20250516184841__Insert_CurriculumAccrediationCSM $$
DELIMITER ;