DELIMITER $$
DROP PROCEDURE IF EXISTS V20250519120214__Alter_AddColumnPerosn $$
CREATE PROCEDURE V20250519120214__Alter_AddColumnPerosn()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='genderIdentityCSMId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `genderIdentityCSMId` BIGINT(30) NULL DEFAULT NULL after governmentSponsorId;
END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_person_genderIdentityCSMId' AND table_name='persons') then
ALTER TABLE persons ADD CONSTRAINT fk_person_genderIdentityCSMId
  FOREIGN KEY (genderIdentityCSMId)
  REFERENCES gender_identity_csm (id)
  ON DELETE RESTRICT;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='ethnicityCSMId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `ethnicityCSMId` BIGINT(30) NULL DEFAULT NULL after genderIdentityCSMId;
END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_person_ethnicityCSMId' AND table_name='persons') then
ALTER TABLE persons ADD CONSTRAINT `fk_person_ethnicityCSMId` 
FOREIGN KEY (`ethnicityCSMId`) REFERENCES `ethnicity_csm` (`id`)
  ON DELETE RESTRICT;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='careLeaverCSMId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `careLeaverCSMId` BIGINT(30) NULL DEFAULT NULL after ethnicityCSMId;
END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_person_careLeaverCSMId' AND table_name='persons') then
ALTER TABLE persons ADD CONSTRAINT `fk_person_careLeaverCSMId` 
FOREIGN KEY (`careLeaverCSMId`) REFERENCES `care_leaver_csm` (`id`)
  ON DELETE RESTRICT;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='sexualOrientationCSMId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `sexualOrientationCSMId` BIGINT(30) NULL DEFAULT NULL after careLeaverCSMId;
END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_person_sexualOrientationCSMId' AND table_name='persons') then
ALTER TABLE persons ADD CONSTRAINT `fk_person_sexualOrientationCSMId` 
FOREIGN KEY (`sexualOrientationCSMId`) REFERENCES `sexual_orientation_csm` (`id`)
  ON DELETE RESTRICT;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='tertTimeAccomodationTypeCSMId')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `tertTimeAccomodationTypeCSMId` BIGINT(40) NULL DEFAULT NULL after sexualOrientationCSMId;
END IF; 

IF NOT EXISTS (SELECT * from information_schema.referential_constraints where constraint_schema=database() and constraint_name='fk_person_tertTimeAccomodationTypeCSMId' AND table_name='persons') then
ALTER TABLE persons ADD CONSTRAINT `fk_person_tertTimeAccomodationTypeCSMId` 
FOREIGN KEY (`tertTimeAccomodationTypeCSMId`) REFERENCES `term_time_accomodation_type_csm` (`id`)
  ON DELETE RESTRICT;
END IF;


IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' AND column_name='uCASSchemeCode')) THEN 
ALTER TABLE `persons` 
ADD COLUMN `uCASSchemeCode` varchar(255) NULL DEFAULT NULL ;

END IF; 

END $$
CALL V20250519120214__Alter_AddColumnPerosn() $$
DROP PROCEDURE IF EXISTS V20250519120214__Alter_AddColumnPerosn $$
DELIMITER ;