DELIMITER $$
DROP PROCEDURE IF EXISTS getAppSubmissionDetails $$
CREATE PROCEDURE getAppSubmissionDetails(IN transdate DATE)
BEGIN
select "USER_ID"	as 	user_id, "SUBMISSION"	as 	submission, "RDAP"	as 	rdap, "RDBL NAME"	as 	rdbl_name, "NIC"	as 	nic, "FIRST NAME"	as 	first_name, "LAST NAME"	as 	last_name, "MAIDEN NAME"	as 	maiden_name, "INTAKE"	as 	intake, "INTAKE FORMATTED"	as 	intake_formatted, "LOGIN EMAIL"	as 	login_email, "CONTACT EMAIL"	as 	contact_email, "PHONE"	as 	phone, "MOBILE"	as 	mobile, "ADDRESS"	as 	address, "COUNTRY"	as 	country, "PROGRAMME 1ψPROGRAMME 2ψPROGRAMME 3ψPROGRAMME 4"	as 	programme, "STATUS"	as 	status, "CURRENCY"	as 	currency, "AMOUNT"	as 	amount
UNION ALL
select a.code as user_id, 1 as submission,  a.code as rdap,  GROUP_CONCAT(DISTINCT bill.billNo SEPARATOR 'ψ' ) as rdbl_name, ap.nationalID as nic,
ap.firstName as first_name, ap.lastName as last_name, '' as maiden_name, b.batchName as intake, b.batchName as intake_formatted,
ap.emailId as login_email, ap.emailId as contact_email, ap.phoneNo as phone, ap.mobileNumber as mobile,
concat(ad.addressText, ct.cityName) as address, cnt.countryName as country, GROUP_CONCAT(DISTINCT p.programName SEPARATOR 'ψ' ) as programme, 'Active' as status, 
GROUP_CONCAT(DISTINCT c.currencyCode SEPARATOR 'ψ')  as currency,  CONVERT(sum(fadj.adjustedAmount), CHAR) as amount 
from receipt_header rh 
join fee_adjustment_master fadj on fadj.receiptHeaderId = rh.id and rh.status = 'SETTLED'
join fee_adjustment_details fadjd on fadjd.adjustmentMasterId = fadj.id
join bill_header bill on fadjd.billHeaderId = bill.id
join billed_user_type utype on bill.raiseBillFor = utype.id and upper(utype.billedUserType)='APPLICANT'
join currency c on rh.currencyId = c.id
join application a on a.id=bill.applicantId
join applicant_person ap on a.applicantPersonId = ap.id
join application_program aprog on a.id = aprog.applicationId
join programs p on aprog.programId = p.id
join prog_batch_seat_config pbsc on aprog.progBatchSeatConfigId = pbsc.id and bill.programBatchSeatConfigId = pbsc.id
join batches b on pbsc.programBatchId = b.id
left join applicant_address ad on ap.id = ad.applicantPersonId and ad.addressTypeId=5
left join country cnt on ap.countryId = cnt.id
left join city ct on ad.cityId = ct.id
where date(fadjd.adjustmentDate) = transdate
group by a.id;
END $$
DELIMITER ;