DELIMITER $$
DROP PROCEDURE IF EXISTS V20250610122848__Create_sponsor_invoice $$
CREATE PROCEDURE V20250610122848__Create_sponsor_invoice()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='sponsor_invoice')) THEN 
CREATE TABLE `sponsor_invoice` (
  `id` BIGINT NOT NULL  AUTO_INCREMENT,
  `sponsorInvoiceNo` VARCHAR(255) NOT NULL,
  `invoiceDate` DATE NOT NULL,
  `sponsorId` BIGINT NOT NULL,
  `invoiceAmount` double(20,2) NULL,
  `isInvoiceSent` bit(1) default false,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_sponsor_invoice_to_sponsor_idx`(`sponsorId`),
  INDEX `fk_sponsor_invoice_to_user_idx` (`lastUpdatedBy`) ,
  
  CONSTRAINT `fk_sponsor_invoice_to_sponsor_idx` 
	FOREIGN KEY (`sponsorId`) 
	REFERENCES `sponsors`(`id`)
    ON DELETE RESTRICT
	ON UPDATE RESTRICT,
 
  CONSTRAINT `fk_sponsor_invoice_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20250610122848__Create_sponsor_invoice () $$ 
DROP PROCEDURE IF EXISTS V20250610122848__Create_sponsor_invoice $$ 
DELIMITER ;