DELIMITER $$
DROP PROCEDURE IF EXISTS V20250613150301__Insert_BulkImportExtendedTimeTableLoader $$
CREATE PROCEDURE V20250613150301__Insert_BulkImportExtendedTimeTableLoader()
BEGIN

IF NOT EXISTS (SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Import Extended TimeTable' and  code ='ExtendedTimeTable') THEN 
INSERT INTO import_utility_master (screenName, fileDirectory, code, lastUpdate, lastUpdatedBy)
 VALUES ('Bulk Import Extended TimeTable', 'extended/ExtendedTimeTable', 'ExtendedTimeTable', now(), '1');
END IF; 

IF EXISTS (SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Import Extended TimeTable' and  code ='ExtendedTimeTable') THEN 

SET @importUtilityMasterId=(SELECT id FROM import_utility_master where code='ExtendedTimeTable');


#-------------------------Is School------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_CODE_NAME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COURSE_CODE_NAME_HEADER', 'Course Code/Name', 'Course Code/Name', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_VARIANTS_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COURSE_VARIANTS_HEADER', 'Course Variants', 'Course Variants', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='SESSION_DATE_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SESSION_DATE_HEADER', 'Session Date', 'Session Date', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='START_TIME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('START_TIME_HEADER', 'Start Time ', 'Start Time ', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='END_TIME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('END_TIME_HEADER', 'End Time', 'End Time', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ROOM_NUMBER_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ROOM_NUMBER_HEADER', 'Room Number', 'Room Number', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='NUMBER_OF_STUDENT_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('NUMBER_OF_STUDENT_HEADER', 'No of Student', 'No of Student', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='TOPICS_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('TOPICS_HEADER', 'Topics', 'Topics', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='TEACHING_HOURS_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('TEACHING_HOURS_HEADER', 'Teaching Hours', 'Teaching Hours', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ASSIGN_FACULTY_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ASSIGN_FACULTY_HEADER', 'Assign Faculty', 'Assign Faculty', '1', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='OPTIONAL_SESSION_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('OPTIONAL_SESSION_HEADER', 'Optional Session', 'Optional Session', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='MARK_ATTENDANCE_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('MARK_ATTENDANCE_HEADER', 'Mandatory to Mark Attendance', 'Mandatory to Mark Attendance', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='SESSION_PLAN_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SESSION_PLAN_HEADER', 'Session Planned', 'Session Planned', '1', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#-------------------------Is College------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_CODE_NAME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COURSE_CODE_NAME_HEADER', 'Course Code/Name', 'Course Code/Name', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COURSE_VARIANTS_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('COURSE_VARIANTS_HEADER', 'Course Variants', 'Course Variants', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='SESSION_DATE_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SESSION_DATE_HEADER', 'Session Date', 'Session Date', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='START_TIME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('START_TIME_HEADER', 'Start Time ', 'Start Time ', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='END_TIME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('END_TIME_HEADER', 'End Time', 'End Time', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ROOM_NUMBER_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ROOM_NUMBER_HEADER', 'Room Number', 'Room Number', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='NUMBER_OF_STUDENT_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('NUMBER_OF_STUDENT_HEADER', 'No of Student', 'No of Student', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='TOPICS_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('TOPICS_HEADER', 'Topics', 'Topics', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='TEACHING_HOURS_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('TEACHING_HOURS_HEADER', 'Teaching Hours', 'Teaching Hours', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='ASSIGN_FACULTY_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ASSIGN_FACULTY_HEADER', 'Assign Faculty', 'Assign Faculty', '0', now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='OPTIONAL_SESSION_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('OPTIONAL_SESSION_HEADER', 'Optional Session', 'Optional Session', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='MARK_ATTENDANCE_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('MARK_ATTENDANCE_HEADER', 'Mandatory to Mark Attendance', 'Mandatory to Mark Attendance', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='SESSION_PLAN_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SESSION_PLAN_HEADER', 'Session Planned', 'Session Planned', '0', now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

END IF; 

END $$
CALL V20250613150301__Insert_BulkImportExtendedTimeTableLoader() $$
DROP PROCEDURE IF EXISTS V20250613150301__Insert_BulkImportExtendedTimeTableLoader $$
DELIMITER ;