DELIMITER $$
DROP PROCEDURE IF EXISTS V20250715120000__Insert_BulkUserCreationLoaderConfig $$
CREATE PROCEDURE V20250715120000__Insert_BulkUserCreationLoaderConfig()
BEGIN

IF EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Users' and  code ='usercreation')) THEN 
	SET @importUtilityMasterId=(SELECT id FROM import_utility_master where code='usercreation');

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FULL_ADDRESS_HEADER' and isSchool='1')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('FULL_ADDRESS_HEADER', 'Full Address', 'Full Address', '1', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COUNTRY_ADDRESS_HEADER' and isSchool='1')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('COUNTRY_ADDRESS_HEADER', 'Country-Address', 'Country-Address', '1', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='STATE_HEADER' and isSchool='1')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('STATE_HEADER', 'State', 'State', '1', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='CITY_ADDRESS_HEADER' and isSchool='1')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('CITY_ADDRESS_HEADER', 'City-Address', 'City-Address', '1', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	-- is college

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='FULL_ADDRESS_HEADER' and isSchool='0')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('FULL_ADDRESS_HEADER', 'Full Address', 'Full Address', '0', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='COUNTRY_ADDRESS_HEADER' and isSchool='0')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('COUNTRY_ADDRESS_HEADER', 'Country-Address', 'Country-Address', '0', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='STATE_HEADER' and isSchool='0')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('STATE_HEADER', 'State', 'State', '0', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

	IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and headerCode='CITY_ADDRESS_HEADER' and isSchool='0')) THEN 
		INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
		`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
		VALUES ('CITY_ADDRESS_HEADER', 'City-Address', 'City-Address', '0', now(), '1', '0', '0', @importUtilityMasterId, '0', NULL);
	END IF; 

END IF; 

END $$
CALL V20250715120000__Insert_BulkUserCreationLoaderConfig() $$
DROP PROCEDURE IF EXISTS V20250715120000__Insert_BulkUserCreationLoaderConfig $$
DELIMITER ;