DELIMITER $$
DROP PROCEDURE IF EXISTS V20250721182741__Update_InactiveAdmissionDataProvider $$
CREATE PROCEDURE V20250721182741__Update_InactiveAdmissionDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS (select * from dydt_data_line_item where dataSourceCode="STUDENT_COURSE_ENROLLMENT_INFO" and dataProviderId = (select id from dydt_data_provider where providerName="Inactive Admission Data Providers"))
 THEN 
update dydt_data_line_item set sqlSelectQueryDef="SELECT 
    c.courseName AS COURSE_NAME, 
    FLOOR ( c.courseCredits) AS COURSE_CREDITS,
    lp.topics AS TEACHING_HOURS,
    lp.term AS LEARNING_HOURS 
    from student_course_enrollment sce
    inner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
    inner join admission adm on adm.id=sce.admissionId
    inner join course_variants cv on cv.id=sce.courseVarientId
    INNER JOIN sections ss on ss.id = sce.sectionId
     left join courses c on c.id=cv.courseId  
     left join lesson_plan lp on lp.courseId=cv.courseId and pbpc.academicTermId=lp.academicTermId and adm.academyLocationId=lp.academyLocationId",
     sqlWhereQueryDef="where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(
     CASE 
            WHEN adm.activeStatus=true
                THEN
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
    pbs.exitDate is null)
                ELSE
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID order by id DESC limit 1 )
                END
    ) and sce.exitDate is null group by sce.courseVarientId union all
    SELECT 
   '<b>Total</b>' AS COURSE_NAME, 
   concat('<b>',COALESCE(SUM(COALESCE(c.courseCredits, 0)), 0),'</b>') AS COURSE_CREDITS,
   concat('<b>',COALESCE(SUM(COALESCE(lp.topics, 0)), 0),'</b>') AS TEACHING_HOURS,
   concat('<b>',COALESCE(SUM(COALESCE(lp.term, 0)), 0),'</b>') AS LEARNING_HOURS
    from student_course_enrollment sce
    inner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
    inner join admission adm on adm.id=sce.admissionId
    inner join course_variants cv on cv.id=sce.courseVarientId
    INNER JOIN sections ss on ss.id = sce.sectionId
     left join courses c on c.id=cv.courseId  
     left join lesson_plan lp on lp.courseId=cv.courseId and pbpc.academicTermId=lp.academicTermId and adm.academyLocationId=lp.academyLocationId where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(
     CASE 
            WHEN adm.activeStatus=true
                THEN
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
    pbs.exitDate is null)
                ELSE
                    (select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID order by id DESC limit 1 )
                END
    ) and sce.exitDate is null" where dataSourceCode="STUDENT_COURSE_ENROLLMENT_INFO" and dataProviderId = (select id from dydt_data_provider where providerName="Inactive Admission Data Providers");
    
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250721182741__Update_InactiveAdmissionDataProvider () $$
DROP PROCEDURE IF EXISTS V20250721182741__Update_InactiveAdmissionDataProvider $$
DELIMITER ;