DELIMITER $$
DROP PROCEDURE IF EXISTS V20250723151726__Insert_ExamConcessionEmailStudent $$
CREATE PROCEDURE V20250723151726__Insert_ExamConcessionEmailStudent()
BEGIN

IF NOT EXISTS ((select id from system_msg_event where code='STUDENT_EXAM_CONCESSION_REQUEST')) THEN 

SET @parentcategoryId=(select id from msg_category where code="SERVICE_REQUEST");
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'STUDENT_EXAM_CONCESSION_REQUEST');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='STUDENT_EXAM_CONCESSION_REQUEST');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '2', @msgSubCategoryId, 'STUDENT_EXAM_CONCESSION_REQUEST', 'Student Exam Concession Request', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Student Exam Concession Request');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_EXAM_CONCESSION_REQUEST_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'STUDENT_EXAM_CONCESSION_REQUEST_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_EXAM_CONCESSION_REQUEST_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'STUDENT_EXAM_CONCESSION_REQUEST_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_EXAM_CONCESSION_REQUEST_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_EXAM_CONCESSION_REQUEST_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_EXAM_CONCESSION_REQUEST_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT T1.id as USER_ID FROM
        	 `service_requests` T1 
		      WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_EXAM_CONCESSION_REQUEST_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
--  Assginee template 
request.id AS ID,
assignee.firstName AS FIRST_NAME,
assignee.lastName AS LAST_NAME,
assignee.printName AS PRINT_NAME,
assignee.emailId AS EMAIL_ID,
request.requestId AS SERVICE_REQUEST_ID,
assigneesalu.salutationName AS ASSIGNEE_SALUTATION,
assigneePerson.firstName AS ASSIGNEE_FIRST_NAME,
assigneePerson.middleName AS ASSIGNEE_MIDDLE_NAME,
assigneePerson.lastName AS ASSIGNEE_LAST_NAME,
assignee.code AS STUDENT_ID,
person.firstName AS STUDENT_FIRST_NAME,
person.lastName AS STUDENT_LAST_NAME,
person.printName AS STUDENT_PRINT_NAME,
person.middleName AS STUDENT_MIDDILE_NAME,
 location.academyCode AS ACADEMY_CODE,
location.locationName AS LOCATION_NAME,
'Exam Concession Request' AS REQUEST_NAME,
DATE(request.requestDate) AS REQUESTED_DATE,
 approverUser.printName AS APPROVER_NAME


from service_requests request 
inner join service_request_settings setting  on request.serviceRequestSettingId=setting.id
inner join users usr on usr.id=request.requester
inner join  students student on usr.id=student.userId
inner join persons person on person.id=student.personId
left outer join salutations salu on salu.id=person.salutationId

-- Assignee joins
inner join users assignee ON assignee.id = setting.defaultAssigneeUserId
inner join persons assigneePerson ON assigneePerson.id = student.personId
left outer join salutations assigneesalu on assigneesalu.id=assigneePerson.salutationId

-- Approver joins 
inner join users approverUser ON approverUser.id = setting.defaultApproverUserId

-- Academy Location joins 
inner join academy_location location on location.id=setting.academyLocationId
where request.type='EXAM_CONCESSION' and  request.id in (namedParams)  limit 1",'{
     "id": 1,
     "searchResultViewColumns": [
	  {
             "id": 1,
             "value": "firstName",
             "resultKey": "FIRST_NAME",
             "displayCode": "",
             "displayOrder": 0
	   },
        {
             "id": 2,
             "value": "lastName",
             "resultKey": "LAST_NAME",
             "displayCode": "",
             "displayOrder": 1
	   },
 	    {
            "id": 3,
             "value": "printName",
             "resultKey": "PRINT_NAME",
             "displayCode": "",
             "displayOrder": 2
 	    },
 	    {
            "id": 4,
             "value": "emailId",
             "resultKey": "EMAIL_ID",
             "displayCode": "",
             "displayOrder": 3
 	   },
       {
            "id": 5,
             "value": "requestId",
             "resultKey": "SERVICE_REQUEST_ID",
             "displayCode": "",
             "displayOrder": 4
 	   },
       
        {
             "id": 6,
             "value": "salutationName",
             "resultKey": "ASSIGNEE_SALUTATION",
             "displayCode": "",
             "displayOrder": 5
         },
          {
             "id": 7,
             "value": "firstName",
             "resultKey": "STUDENT_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
       
          {
             "id": 8,
             "value": "lastName",
             "resultKey": "STUDENT_LAST_NAME",
             "displayCode": "",
             "displayOrder": 7
         },
          {
             "id": 9,
             "value": "printName",
             "resultKey": "STUDENT_PRINT_NAME",
             "displayCode": "",
             "displayOrder": 8
         },
         {
             "id": 10,
             "value": "middleName",
             "resultKey": "STUDENT_MIDDILE_NAME",
             "displayCode": "",
             "displayOrder": 9
         },
         {
             "id": 11,
             "value": "academyCode",
             "resultKey": "ACADEMY_CODE",
             "displayCode": "",
             "displayOrder": 10
         },
          {
             "id": 12,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 11
         },
          {
             "id": 13,
             "value": "Exam Concession Request",
             "resultKey": "REQUEST_NAME",
             "displayCode": "",
             "displayOrder": 12
         },
          {
             "id": 14,
             "value": "requestDate",
             "resultKey": "REQUESTED_DATE",
             "displayCode": "",
             "displayOrder": 13
         },
          {
             "id": 15,
             "value": "printName",
             "resultKey": "APPROVER_NAME",
             "displayCode": "",
             "displayOrder": 14
         },
       {
             "id": 16,
             "value": "assigneeFirstName",
             "resultKey": "ASSIGNEE_FIRST_NAME",
             "displayCode": "",
             "displayOrder": 15
         },
          {
             "id": 17,
             "value": "assigneelastName",
             "resultKey": "ASSIGNEE_LAST_NAME",
             "displayCode": "",
             "displayOrder": 16
         },
         {
             "id": 18,
             "value": "studentId",
             "resultKey": "STUDENT_ID",
             "displayCode": "",
             "displayOrder": 17
         }
 ]}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='STUDENT_EXAM_CONCESSION_REQUEST');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='STUDENT_EXAM_CONCESSION_REQUEST');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='STUDENT_EXAM_CONCESSION_REQUEST_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Student Exam Concession Request Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Student Exam Concession Request Template',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Your Exam Concession Application Has Been Submitted',
'<html>
<head>
</head>
<body>
<p> Dear Student 
You have submitted your concessions application successfully. Track the 
progress of your application regularly on SUNStudent, by referring to pages 11–
13, “Process 3: How to access your concessions letter on the student portal”, on 
the link below:
Student Guide – How to raise an exam concession and view concession letter >> </p>
</body>
</html>
');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'2','Your Exam Concession Application Has Been Submitted',
'<html>
<head>
</head>
<body>
<p> Dear Student 
You have submitted your concessions application successfully. Track the 
progress of your application regularly on SUNStudent, by referring to pages 11–
13, “Process 3: How to access your concessions letter on the student portal”, on 
the link below:
Student Guide – How to raise an exam concession and view concession letter >> </p>
</body>
</html>
');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'4','Your Exam Concession Application Has Been Submitted',
'<html>
<head>
</head>
<body>
<p> Dear Student 
You have submitted your concessions application successfully. Track the 
progress of your application regularly on SUNStudent, by referring to pages 11–
13, “Process 3: How to access your concessions letter on the student portal”, on 
the link below:
Student Guide – How to raise an exam concession and view concession letter >> </p>
</body>
</html>
');

END IF; 

END $$
CALL V20250723151726__Insert_ExamConcessionEmailStudent() $$
DROP PROCEDURE IF EXISTS V20250723151726__Insert_ExamConcessionEmailStudent $$
DELIMITER ;