DELIMITER $$
DROP PROCEDURE IF EXISTS V20250923175005__Create_Index_applicant_person $$
CREATE PROCEDURE V20250923175005__Create_Index_applicant_person()
BEGIN

IF EXISTS (SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() 
AND table_name='applicant_person' 
AND column_name IN ('nationalID','firstName', 'lastName', 'emailId','mobileCountryCode','mobileNumber')) THEN
CREATE INDEX idx_person_nationalid ON applicant_person (nationalID);
CREATE INDEX idx_person_email ON applicant_person (emailId);
CREATE INDEX idx_person_mobile ON applicant_person (mobileCountryCode, mobileNumber);
CREATE INDEX idx_person_name_mobile ON applicant_person (firstName, lastName, mobileCountryCode, mobileNumber);
CREATE INDEX idx_person_name_email ON applicant_person (firstName, lastName, emailId);
CREATE INDEX idx_person_mobile_email ON applicant_person (mobileCountryCode, mobileNumber, emailId);
END IF;

END $$
CALL V20250923175005__Create_Index_applicant_person () $$ 
DROP PROCEDURE IF EXISTS V20250923175005__Create_Index_applicant_person $$ 
DELIMITER ;