DELIMITER $$
DROP PROCEDURE IF EXISTS V20250929154513__Update_StudentCourseEnrollmentRegDynDoc $$
CREATE PROCEDURE V20250929154513__Update_StudentCourseEnrollmentRegDynDoc()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @dataProviderId=(select id from dydt_data_provider where providerName="Registration Confirmation Letter Dynamic Document" limit 1);
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' and dataProviderId=@dataProviderId limit 1)) THEN 
update dydt_data_line_item set sqlSelectQueryDef = "SELECT 
    COURSE_CODE,
    COURSE_NAME,
    COURSE_CREDITS,
    PERIOD,
    EXAM_DATE,
    EXAM_START_TIME,
    EXAM_END_TIME,
    YEARLY_MODULE,
    COURSE_ENROLLMENT_BILL_AMOUNT,
    MODULE_TYPE,
    ENROLLMENT_STATUS
FROM (
    SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
           IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
           FLOOR(c.courseCredits) AS COURSE_CREDITS, 
           pbpc.printName AS PERIOD,
           ss.examDate AS EXAM_DATE, 
           DATE_FORMAT(ss.examStartTime,'%h:%i %p') AS EXAM_START_TIME, 
           DATE_FORMAT(ss.examEndTime,'%h:%i %p') AS EXAM_END_TIME,
           IF(program_courses.isOfferedYearly = 1,'Yes','No') AS YEARLY_MODULE,
           bh.totalAmount as COURSE_ENROLLMENT_BILL_AMOUNT,
           sce.enrollCourseStatus as MODULE_TYPE,
           'Enrolled' as ENROLLMENT_STATUS,
           pbpc.id AS PERIOD_ID,   -- used only for grouping & ordering
           c.id AS COURSE_ID
    FROM student_course_enrollment sce
    INNER JOIN prog_batch_period_config pbpc ON sce.programBatchPeriodConfigId=pbpc.id
    LEFT JOIN period_year py ON pbpc.periodYearId=py.id
    INNER JOIN drop_down dd ON dd.name='Yearly Proof of Registration'
    INNER JOIN admission adm ON adm.id=sce.admissionId
    INNER JOIN course_variants cv ON cv.id=sce.courseVarientId
    INNER JOIN sections ss ON ss.id = sce.sectionId
    LEFT JOIN courses c ON c.id=cv.courseId
    LEFT JOIN courses co ON co.id = c.parentCourseId
    LEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId 
                              AND pbpc.programBatchId = program_courses.programBatchId
    LEFT JOIN bill_header bh ON sce.billId=bh.id" , 
 resultColumnsDef  ='COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD, COURSE_ENROLLMENT_BILL_AMOUNT, MODULE_TYPE, EXAM_DATE, EXAM_START_TIME, EXAM_END_TIME,YEARLY_MODULE ,ENROLLMENT_STATUS',
sqlWhereQueryDef = "WHERE adm.id=PRM_ADMISSION_ID 
      AND (
            (LOWER(dd.value)='no' 
             AND sce.programBatchPeriodConfigId>=(
                 SELECT pbs.progBatchPeriodConfigId 
                 FROM program_batch_students pbs 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             )) 
            OR 
            (LOWER(dd.value)='yes' 
             AND py.id=(
                 SELECT pyp.id 
                 FROM program_batch_students pbs 
                 JOIN prog_batch_period_config pbpcp ON pbs.progBatchPeriodConfigId=pbpcp.id 
                 INNER JOIN period_year pyp ON pbpcp.periodYearId=pyp.id 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             ))
          )
      AND sce.exitDate IS NULL 
      AND adm.activeStatus=true  

    UNION ALL

    SELECT IFNULL(co.courseCode, c.courseCode) AS COURSE_CODE,
           IFNULL(co.courseName, c.courseName) AS COURSE_NAME,
           FLOOR(c.courseCredits) AS COURSE_CREDITS, 
           pbpc.printName AS PERIOD,
           ss.examDate AS EXAM_DATE, 
           DATE_FORMAT(ss.examStartTime,'%h:%i %p') AS EXAM_START_TIME, 
           DATE_FORMAT(ss.examEndTime,'%h:%i %p') AS EXAM_END_TIME,
           IF(program_courses.isOfferedYearly = 1,'Yes','No') AS YEARLY_MODULE,
           bh.totalAmount as COURSE_ENROLLMENT_BILL_AMOUNT,
           sce1.enrollCourseStatus as MODULE_TYPE,
           'Withdrawn' as ENROLLMENT_STATUS,
           pbpc.id AS PERIOD_ID,   -- used only for grouping & ordering
           c.id AS COURSE_ID
    FROM prog_batch_course_details sce
    JOIN student_course_enrollment sce1 
         ON sce1.admissionId=sce.admissionId 
        AND sce1.courseVarientId=sce.courseVarientId 
        AND sce.sectionId=sce1.sectionId 
        AND sce1.programBatchPeriodConfigId=sce.programBatchPeriodConfigId 
        AND sce.whetherDeEnrolled=true
    INNER JOIN prog_batch_period_config pbpc ON sce.programBatchPeriodConfigId=pbpc.id
    LEFT JOIN period_year py ON pbpc.periodYearId=py.id
    INNER JOIN drop_down dd ON dd.name='Yearly Proof of Registration'
    INNER JOIN admission adm ON adm.id=sce.admissionId
    INNER JOIN course_variants cv ON cv.id=sce.courseVarientId
    INNER JOIN sections ss ON ss.id = sce.sectionId
    LEFT JOIN courses c ON c.id=cv.courseId
    LEFT JOIN courses co ON co.id = c.parentCourseId
    LEFT JOIN program_courses ON c.parentCourseId = program_courses.courseId 
                              AND pbpc.programBatchId = program_courses.programBatchId
    LEFT JOIN bill_header bh ON sce1.billId=bh.id
    WHERE adm.id=PRM_ADMISSION_ID 
      AND (
            (LOWER(dd.value)='no' 
             AND sce.programBatchPeriodConfigId>=(
                 SELECT pbs.progBatchPeriodConfigId 
                 FROM program_batch_students pbs 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             )) 
            OR 
            (LOWER(dd.value)='yes' 
             AND py.id=(
                 SELECT pyp.id 
                 FROM program_batch_students pbs 
                 JOIN prog_batch_period_config pbpcp ON pbs.progBatchPeriodConfigId=pbpcp.id 
                 INNER JOIN period_year pyp ON pbpcp.periodYearId=pyp.id 
                 WHERE pbs.admissionId=PRM_ADMISSION_ID 
                   AND pbs.isCurrentPeriod=true 
                   AND pbs.isCurrentSection=true 
                   AND pbs.exitDate IS NULL
             ))
          )
      AND adm.activeStatus=true
) AS unioned
GROUP BY  unioned.COURSE_ID
ORDER BY unioned.PERIOD_ID DESC"

where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO' and dataProviderId=@dataProviderId;

SET @dydtdatalinitemId=(SELECT id FROM dydt_data_line_item WHERE dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO'  AND dataProviderId = @dataProviderId LIMIT 1);

IF NOT EXISTS ((SELECT * FROM dydt_templateparams_translations WHERE translationCode = 'ENROLLMENT_STATUS' and translationValue = 'Enrollment Status' and dataProviderLineItemId=@dydtdatalinitemId)) THEN 
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ENROLLMENT_STATUS', 'Enrollment Status',@dydtdatalinitemId);
END IF;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20250929154513__Update_StudentCourseEnrollmentRegDynDoc () $$
DROP PROCEDURE IF EXISTS V20250929154513__Update_StudentCourseEnrollmentRegDynDoc $$
DELIMITER ;