DELIMITER $$

DROP PROCEDURE IF EXISTS V20251028111127__Alter_PaymentLink $$
CREATE PROCEDURE V20251028111127__Alter_PaymentLink()
BEGIN
    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.COLUMNS 
        WHERE table_schema = DATABASE() 
          AND table_name = 'payment_link'  
          AND column_name = 'applicantId'
    ) THEN
        ALTER TABLE payment_link
        ADD COLUMN applicantId BIGINT(20) DEFAULT NULL AFTER studentId;
    END IF;

    IF NOT EXISTS (
        SELECT 1
        FROM information_schema.referential_constraints 
        WHERE constraint_schema = DATABASE() 
          AND constraint_name = 'FK_payment_link_FK_applicantId'
          AND table_name = 'payment_link'
    ) THEN
        ALTER TABLE payment_link  
        ADD CONSTRAINT FK_payment_link_FK_applicantId 
        FOREIGN KEY (applicantId) REFERENCES application (id);
    END IF;
END $$

CALL V20251028111127__Alter_PaymentLink() $$

DROP PROCEDURE IF EXISTS V20251028111127__Alter_PaymentLink $$

DELIMITER ;
