
CREATE TABLE `fee_adjustment_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `voucherType` varchar(45) DEFAULT NULL,
  `voucherMode` varchar(451) DEFAULT NULL,
  `adjustedAmount` double DEFAULT NULL,
  `balanceAmount` double DEFAULT NULL,
  `instrumentId` bigint(20) DEFAULT NULL,
  `receiptHeaderId` bigint(20) DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `paymentHeaderId` bigint(20) DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Ref324_idx` (`lastUpdatedBy`),
  KEY `Refreceiptpaymentinstrument4555_idx` (`instrumentId`),
  KEY `Refreceiptheader344_idx` (`receiptHeaderId`),
  KEY `Refpaymentheader5463_idx` (`paymentHeaderId`),
  CONSTRAINT `Refpaymentheader5463` FOREIGN KEY (`paymentHeaderId`) REFERENCES `payment_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refreceiptheader344` FOREIGN KEY (`receiptHeaderId`) REFERENCES `receipt_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refreceiptpaymentinstrument4555` FOREIGN KEY (`instrumentId`) REFERENCES `receipt_payment_instrument` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refuser6456` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `fee_adjustment_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `voucherType` varchar(45) DEFAULT NULL,
  `voucherMode` varchar(45) DEFAULT NULL,
  `adjustedAmount` double DEFAULT NULL,
  `balanceAmount` double DEFAULT NULL,
  `billHeaderId` bigint(20) DEFAULT NULL,
  `adjustmentMasterId` bigint(20) DEFAULT NULL,
  `adjustmentDate` date DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Refuser785_idx` (`lastUpdatedBy`),
  KEY `Ref4757_idx` (`billHeaderId`),
  KEY `RefadjustmentMaster2344_idx` (`adjustmentMasterId`),
  CONSTRAINT `Ref4757` FOREIGN KEY (`billHeaderId`) REFERENCES `bill_header` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `RefadjustmentMaster2344` FOREIGN KEY (`adjustmentMasterId`) REFERENCES `fee_adjustment_master` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refuser785` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


ALTER TABLE `receipt_header` 
ADD COLUMN `voucherMode` VARCHAR(45) NULL AFTER `lastUpdate`,
ADD COLUMN `receiptType` VARCHAR(45) NULL AFTER `voucherMode`;