DROP VIEW IF EXISTS `student_attendance_dashboard_student_wise_student`;
CREATE VIEW `pnc_dashboard_top_and_bottom_attendance_student_wise` AS
 select     
        programs.id as programId,
        batches.id as batchId,
        prog_batch_period_config.id as periodId,
        sections.id as sectionId,
        admission.code as studentId,
        users.printName as studentName,
        programs.programNameToBePrint as programName,
        batches.batchName,        
        `student_attendance_dashboard_student_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_student_wise`.`admissionId` AS `admissionId`,
        sum(`student_attendance_dashboard_student_wise`.`presentRecords`) AS `presentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`absentRecords`) AS `absentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`totalRecords`) AS `totalReocrds`,
        round(((sum(`student_attendance_dashboard_student_wise`.`presentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `presentPercentage`,
        round(((sum(`student_attendance_dashboard_student_wise`.`absentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `absentPercentage`
    from
        `student_attendance_dashboard_student_wise`
    left join admission on  student_attendance_dashboard_student_wise.admissionId = admission.id
    left join programs on programs.id = admission.programId
    left join users on admission.studentId = users.id
    left join batches on admission.batchId = batches.id
    left join prog_batch_period_config on prog_batch_period_config.programBatchId = batches.id
    left join sections on sections.periodId = prog_batch_period_config.id
    group by `student_attendance_dashboard_student_wise`.`admissionId`;


    
DROP VIEW IF EXISTS `student_attendance_dashboard_section_wise_section`;
CREATE VIEW `pnc_dashboard_top_and_bottom_program_absenteeism` AS
select 
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `programs`.`programCode` AS `programCode`,
        `programs`.`programNameToBePrint` AS `programNameToBePrint`,
        `batches`.`batchName` AS `batchName`,
        `sections`.`sectionCode` AS `sectionCode`,
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        `student_attendance_dashboard_section_wise`
        left join `sections` ON `student_attendance_dashboard_section_wise`.`sectionId` = `sections`.`id`
        left join `prog_batch_period_config` ON `sections`.`periodId` = `prog_batch_period_config`.`id`
        left join `batches` ON `prog_batch_period_config`.`programBatchId` = `batches`.`id`
        left join `programs` ON `batches`.`programId` = `programs`.`id`
    where
        `sections`.`periodId` is not null
    group by `student_attendance_dashboard_section_wise`.`sectionId`;


    
DROP VIEW IF EXISTS `student_attendance_dashboard_section_wise_variant`;
CREATE VIEW `pnc_dashboard_top_and_bottom_course_absenteeism` AS
 select 
        courses.courseCode, courses.courseName,
        course_variants.courseVariantCode,     
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_section_wise`.`courseId` AS `courseId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `student_attendance_dashboard_section_wise`.`courseVariantId` AS `courseVariantId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        `student_attendance_dashboard_section_wise`
        left join courses on student_attendance_dashboard_section_wise.courseId = courses.id
        left join course_variants on student_attendance_dashboard_section_wise.courseVariantId = course_variants.id
    where
        (`student_attendance_dashboard_section_wise`.`courseVariantId` is not null)
    group by `student_attendance_dashboard_section_wise`.`courseVariantId`;

