drop view if exists evaluation_group_specific;
create view evaluation_group_specific as
    select 
        batches.programId,
        program_batch_students.programBatchId,
        evaluation_group.id,
        examination_result.admissionId,
        users.printName,
        evaluation_group.evaluationGroupCode,
        sum(eval_seq_detail.maxMarks) as markObtainedFrom,
        sum(examination_result.finalMarks) as markObtained,
        avg(examination_result.gradePoints) as gradePoint 
    from
        examination_result
            left join
        program_batch_students ON examination_result.admissionId = program_batch_students.admissionId
            left join
        eval_seq_detail ON examination_result.evaluationDetailSequenceId = eval_seq_detail.id
            left join
        evaluation_group ON examination_result.evaluationGroupId = evaluation_group.id
            left join
        admission ON examination_result.admissionId = admission.id
            left join
        students ON admission.studentId = students.userId
            left join
        users ON students.userId = users.id
            left join
        batches ON program_batch_students.programBatchId = batches.id
            left join
        programs ON batches.programId = programs.id
    group by examination_result.evaluationGroupId , examination_result.admissionId;
    
drop view if exists evaluaton_group_course_specific;
create view evaluaton_group_course_specific as 
select examination_result.evaluationGroupId, examination_result.admissionId, evaluation_sequence.id, courses.courseName, 
sections.sectionCode, evaluation_plan.evaluationPlanNumber,
eval_seq_detail.weightage,  sum(eval_seq_detail.maxMarks) as markObtainedFrom, sum(examination_result.finalMarks) as markObtained,
examination_result.gradePoints
from examination_result 
left join eval_seq_detail on examination_result.evaluationDetailSequenceId=eval_seq_detail.id
left join evaluation_sequence on eval_seq_detail.evalSequenceId=evaluation_sequence.id
left join evaluation_plan_level_two on evaluation_sequence.evalPlanLevelTwoId  =evaluation_plan_level_two.id
left join evaluation_plan_level_one on evaluation_plan_level_two.evalPlanLevelOneId =evaluation_plan_level_one.id
left join evaluation_plan on evaluation_plan_level_one.evaluationPlanId=evaluation_plan.id
left join courses on evaluation_plan.courseId=courses.id
left join program_batch_students on examination_result.admissionId=program_batch_students.admissionId
left join sections on program_batch_students.sectionId=sections.id
group by evaluation_plan.courseId;