CREATE TABLE `exam_room_allocation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `groupDateBatchCenterId` bigint(20) DEFAULT NULL,
  `internalRoomId` bigint(20) DEFAULT NULL,
  `externalRoomId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `Refinternalroom765_idx` (`internalRoomId`),
  KEY `Refexternalroom876_idx` (`externalRoomId`),
  KEY `Refusers767_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refexternalroom876` FOREIGN KEY (`externalRoomId`) REFERENCES `center_room_details` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refinternalroom765` FOREIGN KEY (`internalRoomId`) REFERENCES `resources` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refusers767` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `exam_room_invigilator_allocation` (
  `id` bigint(20) NOT NULL,
  `InvigilatorId` bigint(20) DEFAULT NULL,
  `roomAllocationId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `Refinvigilator32_idx` (`InvigilatorId`),
  KEY `Refroomallocation876_idx` (`roomAllocationId`),
  KEY `Refusers67_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refusers878` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refinvigilator` FOREIGN KEY (`InvigilatorId`) REFERENCES `supervisor_allocation` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refroomallocation` FOREIGN KEY (`roomAllocationId`) REFERENCES `exam_room_allocation` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `exam_room_student_allocation` (
  `id` bigint(20) NOT NULL,
  `timeSlotId` bigint(20) DEFAULT NULL,
  `roomAllocationId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `examtimeslot765_idx` (`timeSlotId`),
  KEY `roomallocation554_idx` (`roomAllocationId`),
  KEY `Refusers873_idx` (`lastUpdatedBy`),
  CONSTRAINT `Refusers873` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `examtimeslot765` FOREIGN KEY (`timeSlotId`) REFERENCES `exam_timeslot` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `roomallocation554` FOREIGN KEY (`roomAllocationId`) REFERENCES `exam_room_allocation` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
