ALTER TABLE `application_payment_details` DROP COLUMN `application_id`,
DROP INDEX `application_foreign_key`,
DROP FOREIGN KEY `application_foreign_key`; 

DROP TABLE IF EXISTS `application_payment_details`;

CREATE TABLE `application_payment_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `paid_by` varchar(100)  NOT NULL,
  `payment_mode` varchar(50)  NOT NULL,
  `instrument_number` varchar(50)  DEFAULT NULL,
  `instrument_date` date DEFAULT NULL,
  `instrument_amount` double NOT NULL,
  `instrument_drawn_on` varchar(255)  DEFAULT NULL,
  `payment_remark` varchar(255)  DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `application` ADD COLUMN `applicationPaymentDetailId` BIGINT NULL AFTER `submissionDate`;

ALTER TABLE `application` ADD CONSTRAINT `fk_application_payment_details` FOREIGN KEY (`applicationPaymentDetailId`) REFERENCES `application_payment_details`(`id`);
