 ALTER TABLE `certificates`
 DROP COLUMN `requestTypeId`, CHANGE `certificateCategory` `certificateCategory` VARCHAR(20) CHARSET utf8 COLLATE utf8_swedish_ci NOT NULL, 
 ADD COLUMN `certificateCode` VARCHAR(80) NOT NULL AFTER `certificateCategory`, 
 ADD COLUMN `id` BIGINT NOT NULL AUTO_INCREMENT AFTER `certificateCode`, 
 ADD COLUMN `certificateName` VARCHAR(100) NOT NULL AFTER `id`, 
 ADD COLUMN `whetherOnlyOrganisational` BIT NOT NULL AFTER `certificateName`, 
 DROP PRIMARY KEY, ADD PRIMARY KEY (`id`), DROP FOREIGN KEY `Refrequest_types2209`; 
 
 ALTER TABLE `certificates`   
  ADD COLUMN `lastUpdate` TIMESTAMP NOT NULL AFTER `whetherOnlyOrganisational`,
  ADD COLUMN `lastUpdatedBy` BIGINT NOT NULL AFTER `lastUpdate`,
  ADD CONSTRAINT `certificate_lastupdate_user_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
  
 
 ALTER TABLE `request_types`   
  CHANGE `serviceRequestGroup` `serviceRequestGroup` VARCHAR(70) CHARSET utf8 COLLATE utf8_swedish_ci NULL,
  CHANGE `itemCode` `requestTypeCode` VARCHAR(255) CHARSET utf8 COLLATE utf8_swedish_ci NULL,
  CHANGE `itemValue` `requestTypeName` VARCHAR(255) CHARSET utf8 COLLATE utf8_swedish_ci NULL,
  ADD COLUMN `type` VARCHAR(50) NOT NULL AFTER `lastUpdate`;
  
  
  ALTER TABLE `request_types` ADD COLUMN `feeRelatedCategory` VARCHAR(60) NULL AFTER `type`; 
  
set foreign_key_checks=0; 
   
  ALTER TABLE `free_form_request_categories`   
  CHANGE `id` `id` BIGINT(20) NOT NULL AUTO_INCREMENT;
  
 ALTER TABLE `free_form_request_types`   
  DROP COLUMN `requestTypeId`, 
  ADD COLUMN `id` BIGINT NOT NULL AUTO_INCREMENT AFTER `categoryId`,
  ADD COLUMN `itemCode` VARCHAR(255) NOT NULL AFTER `id`,
  ADD COLUMN `itemValue` VARCHAR(255) NOT NULL AFTER `itemCode`,
  ADD COLUMN `lastUpdatedBy` BIGINT NULL AFTER `itemValue`,
  ADD COLUMN `lastUpdate` TIMESTAMP NOT NULL AFTER `lastUpdatedBy`, 
  DROP PRIMARY KEY,
  ADD PRIMARY KEY (`id`),
  DROP FOREIGN KEY `Refrequest_types2211`,
  ADD CONSTRAINT `free_form_request_type_user_fk` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`);
   
 set foreign_key_checks=1;  
  
ALTER TABLE `service_request_settings`   
  ADD COLUMN `type` VARCHAR(50) NOT NULL AFTER `defaultApproverUserId`,
  ADD COLUMN `whetherDocumentRequired` BIT NOT NULL AFTER `type`,
  ADD COLUMN `certificateId` BIGINT NULL AFTER `whetherDocumentRequired`,
  ADD COLUMN `freeFormRequestTypeId` BIGINT NULL AFTER `certificateId`,
  ADD CONSTRAINT `srs_certificate_fk` FOREIGN KEY (`certificateId`) REFERENCES `certificates`(`id`),
  ADD CONSTRAINT `free_form_srs_fk` FOREIGN KEY (`freeFormRequestTypeId`) REFERENCES `free_form_request_types`(`id`);

