/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import in.serosoft.cb.model.SearchConfigDTO;
import in.serosoft.cb.model.SearchConfigIdModel;
import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SearchConfigurationApp {
    public static void main(String[] args) throws IOException {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = (SearchConfiguratonService)appContext.getBean("searchConfiguratonService");
        String fileName = "XMLParser/cbxml/FEE_DO_MAPPING_LISTING.xml";
        Path filePath = PropertiesFileManager.getSourceDirPath(fileName);
        InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
        SearchConfigDTO searchConfigDTO = ConfigurationReader.readXmlFile(inputStream);
        SearchConfigIdModel searchConfigIdModel = searchConfiguratonService.getSearchConfigModel(searchConfigDTO.getConfigCode());
        searchConfiguratonService.configure(searchConfigDTO, searchConfigIdModel);
        System.out.println("----Done----");
        SearchConfigurationApp.disableSortingForAggregateColumns(searchConfiguratonService, searchConfigDTO.getSearchResultViews());
        searchConfiguratonService.deleteOldSearchConfigData(searchConfigIdModel);
        ((ConfigurableApplicationContext)appContext).close();
    }

    private static void disableSortingForAggregateColumns(SearchConfiguratonService searchConfiguratonService, List<SearchResultViewDTO> searchResultViews) {
        for (SearchResultViewDTO searchResultViewDTO : searchResultViews) {
            searchConfiguratonService.disableSortingForAggregateColumns(searchResultViewDTO.getViewCode());
        }
    }
}

