/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class WarFileUpdater {
    private static final String constantsWarTargetPath = "resources/js/constants.js";
    private static final String sourceJSFilePath = "constants.js";
    private static final Path sourceJSPath = Paths.get(PropertiesFileManager.OUTPUT_DIRECTORY, "jsFiles");

    public static void main(String[] args) {
        WarFileUpdater.warFileUpdater();
    }

    public static void warFileUpdater() {
        String folderPath = Paths.get(PropertiesFileManager.OUTPUT_DIRECTORY, new String[0]).resolveSibling("webapps").toAbsolutePath().toString();
        HashMap allJsFiles = new HashMap();
        try {
            Files.walk(sourceJSPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".js")).filter(file -> !file.getFileName().toString().equals(sourceJSFilePath)).filter(file -> !file.getFileName().toString().equals("constantscopy.js")).forEach(file -> {
                allJsFiles.put(file.getFileName().toString(), file);
                System.out.println("Files to replace in the war file:" + file);
            });
            Files.walk(Paths.get(folderPath, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                if (file.toString().endsWith(".war")) {
                    WarFileUpdater.replaceFileInWar(file, allJsFiles);
                }
            });
            System.out.println("File replacement completed.");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void replaceFileInWar(Path warFilePath, Map<String, Path> allJsFiles) {
        System.out.println("War file Name:" + warFilePath);
        String tempWarFile = warFilePath + ".new";
        try (JarInputStream warInput = new JarInputStream(new FileInputStream(warFilePath.toString()));
             JarOutputStream warOutput = new JarOutputStream(new FileOutputStream(tempWarFile));){
            int bytesRead;
            byte[] buffer;
            JarEntry entry;
            ArrayList<JarEntry> listMissingEntry = new ArrayList<JarEntry>();
            while ((entry = warInput.getNextJarEntry()) != null) {
                int bytesRead2;
                String entryName = entry.getName();
                if (!entry.isDirectory() && (entryName.endsWith(constantsWarTargetPath) || allJsFiles.containsKey(entryName))) {
                    listMissingEntry.add(entry);
                    System.out.println("Skip:" + entry.getName());
                    continue;
                }
                warOutput.putNextEntry(new JarEntry(entryName));
                byte[] byArray = new byte[1024];
                while ((bytesRead2 = warInput.read(byArray)) != -1) {
                    warOutput.write(byArray, 0, bytesRead2);
                }
                warOutput.closeEntry();
            }
            for (JarEntry jarEntry : listMissingEntry) {
                JarEntry data;
                InputStream sourceInput;
                if (jarEntry.getName().contains(constantsWarTargetPath)) {
                    sourceInput = Files.newInputStream(sourceJSPath.resolve(sourceJSFilePath), new OpenOption[0]);
                    data = new JarEntry(jarEntry.getName());
                    warOutput.putNextEntry(data);
                    buffer = new byte[1024];
                    while ((bytesRead = sourceInput.read(buffer)) != -1) {
                        warOutput.write(buffer, 0, bytesRead);
                    }
                    System.out.println("Add1:" + jarEntry.getName());
                    sourceInput.close();
                    warOutput.closeEntry();
                } else if (allJsFiles != null && allJsFiles.containsKey(jarEntry.getName())) {
                    sourceInput = Files.newInputStream(allJsFiles.get(jarEntry.getName()), new OpenOption[0]);
                    data = new JarEntry(jarEntry.getName());
                    warOutput.putNextEntry(data);
                    buffer = new byte[1024];
                    while ((bytesRead = sourceInput.read(buffer)) != -1) {
                        warOutput.write(buffer, 0, bytesRead);
                    }
                    System.out.println("Add2:" + jarEntry.getName());
                    sourceInput.close();
                    warOutput.closeEntry();
                }
                allJsFiles.remove(jarEntry.getName());
            }
            if (allJsFiles != null && !allJsFiles.isEmpty()) {
                for (Map.Entry entry2 : allJsFiles.entrySet()) {
                    InputStream sourceInput = Files.newInputStream((Path)entry2.getValue(), new OpenOption[0]);
                    JarEntry newEntry = new JarEntry((String)entry2.getKey());
                    warOutput.putNextEntry(newEntry);
                    buffer = new byte[1024];
                    while ((bytesRead = sourceInput.read(buffer)) != -1) {
                        warOutput.write(buffer, 0, bytesRead);
                    }
                    System.out.println("Add3:" + newEntry.getName());
                    sourceInput.close();
                    warOutput.closeEntry();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Files.deleteIfExists(warFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Files.move(Paths.get(tempWarFile, new String[0]), warFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

