/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.cb.helper;

import in.serosoft.cb.dao.SearchTableColumnDAO;
import in.serosoft.cb.dao.SearchTableRelationDAO;
import in.serosoft.cb.entity.BasicSearchConfig;
import in.serosoft.cb.entity.BasicSearchConfigParam;
import in.serosoft.cb.entity.DefaultSearchCriterias;
import in.serosoft.cb.entity.SearchAggregationColumn;
import in.serosoft.cb.entity.SearchConfig;
import in.serosoft.cb.entity.SearchConfigTable;
import in.serosoft.cb.entity.SearchCriteriaOperator;
import in.serosoft.cb.entity.SearchImplicitCriteria;
import in.serosoft.cb.entity.SearchResultEnhancer;
import in.serosoft.cb.entity.SearchResultFormatterParams;
import in.serosoft.cb.entity.SearchResultView;
import in.serosoft.cb.entity.SearchResultViewColumn;
import in.serosoft.cb.entity.SearchResultViewSort;
import in.serosoft.cb.entity.SearchSQLGroup;
import in.serosoft.cb.entity.SearchSQLGroupBy;
import in.serosoft.cb.entity.SearchTable;
import in.serosoft.cb.entity.SearchTableColumn;
import in.serosoft.cb.entity.SearchTableRelation;
import in.serosoft.cb.enumeration.OperatorEnum;
import in.serosoft.cb.helper.ConfigurationHelper;
import in.serosoft.cb.model.BasicSearchConfigDTO;
import in.serosoft.cb.model.BasicSearchConfigParamsDTO;
import in.serosoft.cb.model.DefaultSearchCriteriasDTO;
import in.serosoft.cb.model.SearchAggregateColumnDTO;
import in.serosoft.cb.model.SearchConfigDTO;
import in.serosoft.cb.model.SearchConfigTableDTO;
import in.serosoft.cb.model.SearchImplicitCriteriaDTO;
import in.serosoft.cb.model.SearchResultEnhancerDTO;
import in.serosoft.cb.model.SearchResultFormatterParamsDTO;
import in.serosoft.cb.model.SearchResultViewColumnDTO;
import in.serosoft.cb.model.SearchResultViewDTO;
import in.serosoft.cb.model.SearchResultViewSortDTO;
import in.serosoft.cb.model.SearchSQLGroupByDTO;
import in.serosoft.cb.model.SearchSQLGroupDTO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DTOToEntityConvertor {
    SearchTableRelationDAO searchTableRelationDAO;
    SearchTableColumnDAO searchTableColumnDAO;
    Map<String, SearchTable> searchTablesMap;
    List<SearchTableRelation> searchTableRelations;
    Map<String, SearchConfigTable> searchConfigTablesMap = new HashMap<String, SearchConfigTable>();
    Map<String, SearchResultViewColumn> searchResultViewColumnMap = new HashMap<String, SearchResultViewColumn>();
    Map<String, SearchSQLGroup> searchSQLGroupMap = new HashMap<String, SearchSQLGroup>();
    SearchConfigTable rootSearchConfigTable = new SearchConfigTable();
    SearchResultView defaultSearchResultView = new SearchResultView();

    public DTOToEntityConvertor(Map<String, SearchTable> searchTablesMap, List<SearchTableRelation> searchTableRelations, SearchTableRelationDAO searchTableRelationDAO, SearchTableColumnDAO searchTableColumnDAO) {
        this.searchTablesMap = searchTablesMap;
        this.searchTableRelations = searchTableRelations;
        this.searchTableRelationDAO = searchTableRelationDAO;
        this.searchTableColumnDAO = searchTableColumnDAO;
    }

    public SearchConfig convertSearchConfigDTOToSearchConfig(SearchConfigDTO searchConfigDTO) {
        List<SearchImplicitCriteriaDTO> list;
        List<SearchResultEnhancerDTO> resultEnhancerDTOs;
        List<DefaultSearchCriteriasDTO> defaultSearchCriterias;
        SearchConfig searchConfig = new SearchConfig();
        searchConfig.setConfigCode(searchConfigDTO.getConfigCode());
        HashSet<SearchConfigTable> searchConfigTables = new HashSet<SearchConfigTable>();
        List<SearchConfigTableDTO> searchConfigTableDTOs = searchConfigDTO.getSearchConfigTables();
        for (SearchConfigTableDTO searchConfigTableDTO : searchConfigTableDTOs) {
            SearchConfigTable searchConfigTable = this.convertSearchConfigTableDTOToSearchConfigTable(searchConfigTableDTO);
            searchConfigTable.setSearchConfiguration(searchConfig);
            searchConfigTables.add(searchConfigTable);
            this.searchConfigTablesMap.put(searchConfigTable.getAlias(), searchConfigTable);
            if (searchConfigTableDTO.getRoot() != 1L) continue;
            this.rootSearchConfigTable = searchConfigTable;
        }
        searchConfig.setSearchConfigurationTables(this.fillRelationLinks(searchConfigTables, searchConfigTableDTOs));
        HashSet<SearchResultView> searchResultViews = new HashSet<SearchResultView>();
        List<SearchResultViewDTO> searchResultViewDTOs = searchConfigDTO.getSearchResultViews();
        for (SearchResultViewDTO searchResultViewDTO : searchResultViewDTOs) {
            SearchResultView nextSearchResultView = this.convertSearchResultViewDTOToSearchResultView(searchResultViewDTO);
            nextSearchResultView.setSearchConfiguration(searchConfig);
            searchResultViews.add(nextSearchResultView);
            if (searchResultViewDTO.getDefaultView() == null || searchResultViewDTO.getDefaultView() != 1L) continue;
            this.defaultSearchResultView = nextSearchResultView;
        }
        searchConfig.setSearchResultViews(searchResultViews);
        List<BasicSearchConfigDTO> basicSearchConfigDTOs = searchConfigDTO.getBasicSearchConfigs();
        if (basicSearchConfigDTOs != null) {
            HashSet<BasicSearchConfig> basicSearchConfigurations = new HashSet<BasicSearchConfig>();
            for (BasicSearchConfigDTO basicSearchConfigDTO : basicSearchConfigDTOs) {
                BasicSearchConfig basicSearchConfig = this.convertbasicSearchConfigDTOTobasicSearchConfig(basicSearchConfigDTO);
                basicSearchConfig.setSearchConfiguration(searchConfig);
                basicSearchConfigurations.add(basicSearchConfig);
            }
            searchConfig.setBasicSearchConfigurations(basicSearchConfigurations);
        }
        if ((defaultSearchCriterias = searchConfigDTO.getDefaultSearchCriterias()) != null) {
            HashSet<DefaultSearchCriterias> searchCriterias = new HashSet<DefaultSearchCriterias>();
            for (DefaultSearchCriteriasDTO defaultSearchCriteriasDTO : defaultSearchCriterias) {
                DefaultSearchCriterias searchCriteria = this.converDefaultSearchCriteriasDTOTODefaultSearchCriterias(defaultSearchCriteriasDTO);
                searchCriteria.setSearchConfig(searchConfig);
                searchCriterias.add(searchCriteria);
            }
            searchConfig.setDefaultSearchCriterias(searchCriterias);
        }
        if ((resultEnhancerDTOs = searchConfigDTO.getResultEnhancerConfigs()) != null) {
            HashSet<SearchResultEnhancer> hashSet = new HashSet<SearchResultEnhancer>();
            for (SearchResultEnhancerDTO resultEnhancerDTO : resultEnhancerDTOs) {
                SearchResultEnhancer searchResultEnhancer = this.converDefaultSearchResultEnhancersDTOTOSearchResultEnhancer(resultEnhancerDTO);
                searchResultEnhancer.setSearchConfiguration(searchConfig);
                hashSet.add(searchResultEnhancer);
            }
            searchConfig.setSearchResultEnhancers(hashSet);
        }
        if ((list = searchConfigDTO.getSearchImplicitCriterias()) != null) {
            HashSet<SearchImplicitCriteria> hashSet = new HashSet<SearchImplicitCriteria>();
            for (SearchImplicitCriteriaDTO searchImplicitCriteriaDTO : list) {
                SearchImplicitCriteria searchImplicitCriteria = this.converSearchImplicitCriteriasDTOTOSearchImplicitCriterias(searchImplicitCriteriaDTO);
                searchImplicitCriteria.setSearchConfiguration(searchConfig);
                hashSet.add(searchImplicitCriteria);
            }
            searchConfig.setSearchImplicitCriterias(hashSet);
        }
        searchConfig.setSearchConfigurationTable(this.rootSearchConfigTable);
        searchConfig.setSearchResultView(this.defaultSearchResultView);
        return searchConfig;
    }

    private SearchImplicitCriteria converSearchImplicitCriteriasDTOTOSearchImplicitCriterias(SearchImplicitCriteriaDTO searchImplicitCriteriaDTO) {
        SearchImplicitCriteria searchImplicitCriteria = new SearchImplicitCriteria();
        SearchConfigTable searchConfigurationTable = this.searchConfigTablesMap.get(searchImplicitCriteriaDTO.getSearchConfigTableAlias());
        searchImplicitCriteria.setSearchConfigurationTable(searchConfigurationTable);
        searchImplicitCriteria.setSearchTableColumn(ConfigurationHelper.getSearchTableColumn(searchConfigurationTable.getSearchTableBySearchTableId().getDbTableName(), searchImplicitCriteriaDTO.getSearchTableColumnName(), this.searchTablesMap));
        searchImplicitCriteria.setSecurityCode(searchImplicitCriteriaDTO.getSecurityCode());
        return searchImplicitCriteria;
    }

    private SearchResultEnhancer converDefaultSearchResultEnhancersDTOTOSearchResultEnhancer(SearchResultEnhancerDTO resultEnhancerDTO) {
        SearchResultEnhancer searchResultEnhancer = new SearchResultEnhancer();
        searchResultEnhancer.setMergeKey(resultEnhancerDTO.getMergeKey());
        searchResultEnhancer.setResultColumnsAlias(resultEnhancerDTO.getResultColumnsAlias());
        searchResultEnhancer.setSqlQuery(resultEnhancerDTO.getSqlQuery());
        return searchResultEnhancer;
    }

    private DefaultSearchCriterias converDefaultSearchCriteriasDTOTODefaultSearchCriterias(DefaultSearchCriteriasDTO searchCriteriaDTO) {
        DefaultSearchCriterias defaultSearchCriterias = new DefaultSearchCriterias();
        defaultSearchCriterias.setCriteriaName(searchCriteriaDTO.getCriteriaName());
        SearchConfigTable searchConfigurationTable = this.searchConfigTablesMap.get(searchCriteriaDTO.getSearchConfigTableAlias());
        defaultSearchCriterias.setSearchConfigurationTable(searchConfigurationTable);
        defaultSearchCriterias.setSearchTableColumn(ConfigurationHelper.getSearchTableColumn(this.searchTableColumnDAO, searchConfigurationTable.getSearchTableBySearchTableId().getDbTableName(), searchCriteriaDTO.getSearchTableColumnName(), this.searchTablesMap));
        SearchCriteriaOperator searchCriteriaOperator = new SearchCriteriaOperator();
        searchCriteriaOperator.setId(OperatorEnum.valueOf(searchCriteriaDTO.getSearchCriteriaOperatorName()).getOperatorId());
        defaultSearchCriterias.setSearchCriteriaOperator(searchCriteriaOperator);
        defaultSearchCriterias.setOperandValue(searchCriteriaDTO.getOperandValue());
        return defaultSearchCriterias;
    }

    private BasicSearchConfig convertbasicSearchConfigDTOTobasicSearchConfig(BasicSearchConfigDTO basicSearchConfigDTO) {
        BasicSearchConfig basicSearchConfig = new BasicSearchConfig();
        basicSearchConfig.setConfigCode(basicSearchConfigDTO.getConfigCode());
        List<BasicSearchConfigParamsDTO> basicSearchConfigParamsDTOs = basicSearchConfigDTO.getBasicSearchConfigParams();
        HashSet<BasicSearchConfigParam> basicSearchConfigurationParams = new HashSet<BasicSearchConfigParam>();
        for (BasicSearchConfigParamsDTO basicSearchConfigParamsDTO : basicSearchConfigParamsDTOs) {
            BasicSearchConfigParam basicSearchConfigParam = this.convertBasicSearchConfigParamsDTOToBasicSearchConfigParams(basicSearchConfigParamsDTO);
            basicSearchConfigParam.setBasicSearchConfiguration(basicSearchConfig);
            basicSearchConfigurationParams.add(basicSearchConfigParam);
        }
        basicSearchConfig.setBasicSearchConfigurationParams(basicSearchConfigurationParams);
        return basicSearchConfig;
    }

    private BasicSearchConfigParam convertBasicSearchConfigParamsDTOToBasicSearchConfigParams(BasicSearchConfigParamsDTO basicSearchConfigParamsDTO) {
        BasicSearchConfigParam basicSearchConfigParam = new BasicSearchConfigParam();
        basicSearchConfigParam.setParamCode(basicSearchConfigParamsDTO.getParamCode());
        SearchConfigTable searchConfigurationTable = this.searchConfigTablesMap.get(basicSearchConfigParamsDTO.getSearchConfigTableAlias());
        basicSearchConfigParam.setSearchConfigurationTable(searchConfigurationTable);
        SearchCriteriaOperator searchCriteriaOperator = new SearchCriteriaOperator();
        searchCriteriaOperator.setId(OperatorEnum.valueOf(basicSearchConfigParamsDTO.getSearchCriteriaOperatorName()).getOperatorId());
        basicSearchConfigParam.setSearchCriteriaOperator(searchCriteriaOperator);
        basicSearchConfigParam.setSearchTableColumn(ConfigurationHelper.getSearchTableColumn(this.searchTableColumnDAO, searchConfigurationTable.getSearchTableBySearchTableId().getDbTableName(), basicSearchConfigParamsDTO.getSearchTableColumnName(), this.searchTablesMap));
        if (basicSearchConfigParamsDTO.getLogicalGroupName() != null) {
            basicSearchConfigParam.setLogicalGroupName(basicSearchConfigParamsDTO.getLogicalGroupName());
        } else {
            basicSearchConfigParam.setLogicalGroupName("AND_X");
        }
        return basicSearchConfigParam;
    }

    private Set<SearchConfigTable> fillRelationLinks(Set<SearchConfigTable> searchConfigTables, List<SearchConfigTableDTO> searchConfigTableDTOs) {
        HashSet<SearchConfigTable> linkedSearchConfigTables = new HashSet<SearchConfigTable>();
        for (SearchConfigTable searchConfigTable : searchConfigTables) {
            String relationLinkTableAlias = this.findAlias(searchConfigTable.getAlias(), searchConfigTableDTOs);
            searchConfigTable.setSearchConfigurationTable(this.searchConfigTablesMap.get(relationLinkTableAlias));
            linkedSearchConfigTables.add(searchConfigTable);
        }
        return linkedSearchConfigTables;
    }

    private String findAlias(String alias, List<SearchConfigTableDTO> searchConfigTableDTOs) {
        for (SearchConfigTableDTO searchConfigTableDTO : searchConfigTableDTOs) {
            if (!searchConfigTableDTO.getAlias().equals(alias)) continue;
            return searchConfigTableDTO.getTableSequenceIdentifier();
        }
        return null;
    }

    public SearchConfigTable convertSearchConfigTableDTOToSearchConfigTable(SearchConfigTableDTO searchConfigTableDTO) {
        SearchConfigTable searchConfigTable = new SearchConfigTable();
        searchConfigTable.setAlias(searchConfigTableDTO.getAlias());
        searchConfigTable.setAvailableForCriteriaSearch(searchConfigTableDTO.getAvailableForCriteriaSearch());
        searchConfigTable.setDisplayCode(searchConfigTableDTO.getDisplayCode());
        searchConfigTable.setDisplayOrder(searchConfigTableDTO.getDisplayOrder());
        searchConfigTable.setIsSubQuery(searchConfigTableDTO.getWhetherSubQuery());
        searchConfigTable.setJoinType(searchConfigTableDTO.getJoinType());
        if (this.searchTablesMap.get(searchConfigTableDTO.getSearchTableName()) == null) {
            if (this.searchTablesMap.get(searchConfigTableDTO.getSearchTableName().toLowerCase()) == null) {
                System.out.println("**************searchConfigTableDTO is null for table name: " + searchConfigTableDTO.getSearchTableName());
            } else {
                searchConfigTableDTO.setSearchTableName(searchConfigTableDTO.getSearchTableName().toLowerCase());
            }
        }
        searchConfigTable.setSearchTableBySearchTableId(this.searchTablesMap.get(searchConfigTableDTO.getSearchTableName()));
        searchConfigTable.setSearchTableRelation(ConfigurationHelper.getSearchTableRelation(searchConfigTableDTO, this.searchTableRelations, this.searchTableRelationDAO, this.searchTablesMap));
        return searchConfigTable;
    }

    public SearchResultView convertSearchResultViewDTOToSearchResultView(SearchResultViewDTO searchResultViewDTO) {
        SearchResultView searchResultView = new SearchResultView();
        searchResultView.setViewCode(searchResultViewDTO.getViewCode());
        HashSet<SearchResultViewColumn> searchResultViewColumns = new HashSet<SearchResultViewColumn>();
        List<SearchResultViewColumnDTO> searchResultViewColumnsDTO = searchResultViewDTO.getSearchResultViewColumns();
        if (searchResultViewColumnsDTO != null && !searchResultViewColumnsDTO.isEmpty()) {
            for (SearchResultViewColumnDTO searchResultViewColumnDTO : searchResultViewColumnsDTO) {
                SearchResultViewColumn searchResultViewColumn = this.convertSearchResultViewColumnDTOToSearchResultViewColumn(searchResultViewColumnDTO, searchResultView);
                searchResultViewColumn.setSearchResultView(searchResultView);
                searchResultViewColumns.add(searchResultViewColumn);
                this.searchResultViewColumnMap.put(searchResultViewColumn.getResultKey(), searchResultViewColumn);
            }
        } else if (searchResultViewDTO.getViewCode() != null) {
            System.out.println("**************searchResultViewColumnsDTO is Empty**********************" + searchResultViewDTO.getViewCode());
        }
        HashSet<SearchSQLGroup> searchSQLGroups = new HashSet<SearchSQLGroup>();
        List<SearchSQLGroupDTO> searchSQLGroupDTOs = searchResultViewDTO.getSearchSQLGroups();
        if (searchSQLGroupDTOs != null) {
            for (SearchSQLGroupDTO searchSQLGroupDTO : searchSQLGroupDTOs) {
                SearchSQLGroup searchSQLGroup = this.converSearchSQLGroupDTOtoSearchSQLGroup(searchSQLGroupDTO);
                if (searchSQLGroup == null) continue;
                searchSQLGroup.setSearchResultView(searchResultView);
                searchSQLGroups.add(searchSQLGroup);
                this.searchSQLGroupMap.put(searchSQLGroup.getGroupName(), searchSQLGroup);
            }
            if (searchSQLGroups.size() > 0) {
                searchResultView.setSearchSQLGroups(searchSQLGroups);
            }
        }
        searchResultView.setSearchResultViewColumns(this.fillSearchTableColumns(searchResultViewColumns, searchResultViewColumnsDTO));
        HashSet<SearchResultViewSort> searchResultViewSorts = new HashSet<SearchResultViewSort>();
        List<SearchResultViewSortDTO> searchResultViewSortDTOs = searchResultViewDTO.getSearchResultViewSorts();
        if (searchResultViewSortDTOs != null) {
            for (SearchResultViewSortDTO searchResultViewSortDTO : searchResultViewSortDTOs) {
                SearchResultViewSort searchResultViewSort = this.convertSearchResultViewSortDTOtoSearchResultViewSort(searchResultViewSortDTO);
                searchResultViewSort.setSearchResultView(searchResultView);
                searchResultViewSorts.add(searchResultViewSort);
            }
            searchResultView.setSearchResultViewSorts(searchResultViewSorts);
        }
        return searchResultView;
    }

    private SearchResultViewSort convertSearchResultViewSortDTOtoSearchResultViewSort(SearchResultViewSortDTO searchResultViewSortDTO) {
        SearchResultViewSort searchResultViewSort = new SearchResultViewSort();
        searchResultViewSort.setSortOrder(searchResultViewSortDTO.getSortOrder());
        searchResultViewSort.setSortSequence(searchResultViewSortDTO.getSortSequence());
        searchResultViewSort.setSearchResultViewColumn(this.searchResultViewColumnMap.get(searchResultViewSortDTO.getSearchResultViewColumn()));
        return searchResultViewSort;
    }

    private SearchSQLGroup converSearchSQLGroupDTOtoSearchSQLGroup(SearchSQLGroupDTO searchSQLGroupDTO) {
        if (!searchSQLGroupDTO.getGroupName().equals("")) {
            SearchSQLGroup sqlGroup = new SearchSQLGroup();
            sqlGroup.setId(null);
            sqlGroup.setGroupName(searchSQLGroupDTO.getGroupName());
            sqlGroup.setOrder(searchSQLGroupDTO.getGroupOrder());
            HashSet<SearchSQLGroupBy> searchSQLGroupBies = new HashSet<SearchSQLGroupBy>();
            List<SearchSQLGroupByDTO> searchSQLGroupByDTOs = searchSQLGroupDTO.getSearchSQLGroupBies();
            for (SearchSQLGroupByDTO searchSQLGroupByDTO : searchSQLGroupByDTOs) {
                SearchSQLGroupBy searchSQLGroupBy = this.convertSearchSQLGroupByDTOToSearchSQLGroupBy(searchSQLGroupByDTO);
                searchSQLGroupBy.setSearchSQLGroup(sqlGroup);
                searchSQLGroupBies.add(searchSQLGroupBy);
            }
            sqlGroup.setSearchSQLGroupBies(searchSQLGroupBies);
            return sqlGroup;
        }
        return null;
    }

    private SearchSQLGroupBy convertSearchSQLGroupByDTOToSearchSQLGroupBy(SearchSQLGroupByDTO searchSQLGroupByDTO) {
        SearchSQLGroupBy searchSQLGroupBy = new SearchSQLGroupBy();
        searchSQLGroupBy.setId(null);
        searchSQLGroupBy.setOrder(searchSQLGroupByDTO.getGroupByOrder());
        searchSQLGroupBy.setSearchResultViewColumn(this.searchResultViewColumnMap.get(searchSQLGroupByDTO.getSearchResultViewColumn()));
        return searchSQLGroupBy;
    }

    private Set<SearchResultViewColumn> fillSearchTableColumns(Set<SearchResultViewColumn> searchResultViewColumns, List<SearchResultViewColumnDTO> searchResultViewColumnsDTO) {
        HashSet<SearchResultViewColumn> filledSearchResultViewColumns = new HashSet<SearchResultViewColumn>();
        for (SearchResultViewColumn searchResultViewColumn : searchResultViewColumns) {
            String columnName = this.findColumnName(searchResultViewColumn.getResultKey(), searchResultViewColumnsDTO);
            try {
                String tableName = searchResultViewColumn.getSearchConfigurationTable().getSearchTableBySearchTableId().getDbTableName();
                if (tableName == null || columnName == null) continue;
                SearchTableColumn searchTableColumn = ConfigurationHelper.getSearchTableColumn(this.searchTableColumnDAO, tableName, columnName, this.searchTablesMap);
                if (searchTableColumn == null) {
                    System.out.println("This column is null: " + columnName + " tableName: " + tableName);
                }
                searchResultViewColumn.setSearchTableColumn(searchTableColumn);
                String groupName = this.findGroupName(searchResultViewColumn.getResultKey(), searchResultViewColumnsDTO);
                if (groupName != null && !groupName.equals("")) {
                    searchResultViewColumn.setSearchSQLGroup(this.searchSQLGroupMap.get(groupName));
                }
                filledSearchResultViewColumns.add(searchResultViewColumn);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Found execptions getResultKey: " + searchResultViewColumn.getResultKey() + "DisplayCode: " + searchResultViewColumn.getDisplayCode());
            }
        }
        return filledSearchResultViewColumns;
    }

    private String findColumnName(String resultKey, List<SearchResultViewColumnDTO> searchResultViewColumnsDTO) {
        for (SearchResultViewColumnDTO searchResultViewColumnDTO : searchResultViewColumnsDTO) {
            if (!searchResultViewColumnDTO.getResultKey().equalsIgnoreCase(resultKey)) continue;
            return searchResultViewColumnDTO.getSearchTableColumnName();
        }
        return null;
    }

    private String findGroupName(String resultKey, List<SearchResultViewColumnDTO> searchResultViewColumnsDTO) {
        for (SearchResultViewColumnDTO searchResultViewColumnDTO : searchResultViewColumnsDTO) {
            if (!searchResultViewColumnDTO.getResultKey().equalsIgnoreCase(resultKey) || searchResultViewColumnDTO.getSearchSQLGroupName() == null) continue;
            return searchResultViewColumnDTO.getSearchSQLGroupName();
        }
        return null;
    }

    public SearchResultViewColumn convertSearchResultViewColumnDTOToSearchResultViewColumn(SearchResultViewColumnDTO searchResultViewColumnDTO, SearchResultView searchResultView) {
        SearchResultViewColumn searchResultViewColumn = new SearchResultViewColumn();
        searchResultViewColumn.setId(null);
        searchResultViewColumn.setSortable(true);
        searchResultViewColumn.setDisplayOrder(searchResultViewColumnDTO.getDisplayOrder());
        searchResultViewColumn.setDisplayCode(searchResultViewColumnDTO.getDisplayCode());
        searchResultViewColumn.setResultKey(searchResultViewColumnDTO.getResultKey());
        searchResultViewColumn.setVisibility(searchResultViewColumnDTO.getVisibility());
        searchResultViewColumn.setWhetherHyperlink(searchResultViewColumnDTO.getWhetherHyperlink());
        searchResultViewColumn.setWhetherSchool(searchResultViewColumnDTO.getWhetherSchool());
        if (searchResultViewColumnDTO.getWhetherColorFormat() != null) {
            searchResultViewColumn.setWhetherColorFormat(searchResultViewColumnDTO.getWhetherColorFormat());
        } else if (searchResultViewColumnDTO.getWhetherColorFormat() == null) {
            searchResultViewColumn.setWhetherColorFormat(false);
        }
        if (searchResultViewColumnDTO.getWhetherTotalAmount() != null) {
            searchResultViewColumn.setWhetherTotalAmount(searchResultViewColumnDTO.getWhetherTotalAmount());
        } else if (searchResultViewColumnDTO.getWhetherTotalAmount() == null) {
            searchResultViewColumn.setWhetherTotalAmount(false);
        }
        if (searchResultViewColumnDTO.getSqlFunction() != null) {
            searchResultViewColumn.setSqlFunction(searchResultViewColumnDTO.getSqlFunction());
        }
        if (searchResultViewColumnDTO.getSearchAggregateColumn() != null) {
            SearchAggregationColumn searchAggregationColumn = this.converSearchAggregateColumnDTOtoSearchAggregateColumn(searchResultViewColumnDTO.getSearchAggregateColumn());
            searchResultViewColumn.setSearchAggregationColumn(searchAggregationColumn);
        }
        if (searchResultViewColumnDTO.getFormatter() != null) {
            searchResultViewColumn.setFormatter(searchResultViewColumnDTO.getFormatter());
            SearchResultFormatterParamsDTO searchResultFormatterParamsDTO = searchResultViewColumnDTO.getSearchResultFormatterParams();
            SearchResultFormatterParams searchResultFormatterParams = new SearchResultFormatterParams();
            searchResultFormatterParams.setKey(searchResultFormatterParamsDTO.getFormatterParamskey());
            searchResultFormatterParams.setWhetherResultColumn(searchResultFormatterParamsDTO.getWhetherResultColumn());
            searchResultFormatterParams.setParam(searchResultFormatterParamsDTO.getResultColumnResultKey());
            searchResultViewColumn.setSearchResultFormatterParams(searchResultFormatterParams);
        }
        searchResultViewColumn.setSearchConfigurationTable(this.searchConfigTablesMap.get(searchResultViewColumnDTO.getSearchConfigTableAlias()));
        return searchResultViewColumn;
    }

    private SearchAggregationColumn converSearchAggregateColumnDTOtoSearchAggregateColumn(SearchAggregateColumnDTO searchAggregateColumn) {
        if (!searchAggregateColumn.getSearchTableId().equals("") && !searchAggregateColumn.getSearchTableColumnId().equals("")) {
            SearchAggregationColumn searchAggregationColumn = new SearchAggregationColumn();
            searchAggregationColumn.setId(null);
            searchAggregationColumn.setAliasName(searchAggregateColumn.getAliasName());
            searchAggregationColumn.setAggregateFunction(searchAggregateColumn.getAggregateFunction());
            searchAggregationColumn.setSearchTable(this.searchTablesMap.get(searchAggregateColumn.getSearchTableId()));
            searchAggregationColumn.setSearchTableColumn(ConfigurationHelper.getSearchTableColumn(searchAggregateColumn.getSearchTableId(), searchAggregateColumn.getSearchTableColumnId(), this.searchTablesMap));
            return searchAggregationColumn;
        }
        return null;
    }

    private String toLowerCase(String tableName) {
        if (tableName != null) {
            return tableName.toLowerCase();
        }
        return tableName;
    }
}

