/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen.ciphers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.Security;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;

public class RSADecryption {
    public static void main(String[] args) {
        String privateKeyFilename = null;
        String encryptedData = null;
        RSADecryption rsaDecryption = new RSADecryption();
        if (args.length < 2) {
            System.err.println("Usage: java " + rsaDecryption.getClass().getName() + " Private_Key_Filename Encrypted_String_Data");
            System.exit(1);
        }
        privateKeyFilename = args[0].trim();
        encryptedData = args[1].trim();
        rsaDecryption.decrypt(privateKeyFilename, encryptedData);
    }

    private String decrypt(String privateKeyFilename, String encryptedData) {
        String outputData = null;
        try {
            Security.addProvider(new BouncyCastleProvider());
            String key = RSADecryption.readFileAsString(privateKeyFilename);
            BASE64Decoder b64 = new BASE64Decoder();
            AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey(b64.decodeBuffer(key));
            AsymmetricBlockCipher e = new RSAEngine();
            e = new PKCS1Encoding(e);
            e.init(false, privateKey);
            byte[] messageBytes = RSADecryption.hexStringToByteArray(encryptedData);
            byte[] hexEncodedCipher = e.processBlock(messageBytes, 0, messageBytes.length);
            outputData = new String(hexEncodedCipher);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return outputData;
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

