/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen.ciphers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.security.Security;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class RSAEncryptFile {
    public static void main(String[] args) {
        RSAEncryptFile.encrypt("public1.key", "serosoft_license.lic", "serosoft_license.enc");
    }

    private static void encrypt(String publicKeyFilename, String inputFilename, String encryptedFilename) {
        try {
            Security.addProvider(new BouncyCastleProvider());
            String value = "";
            String key = FileUtils.readFileToString(new File(publicKeyFilename));
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(Base64.decode(key));
            PKCS1Encoding e = new PKCS1Encoding(new RSAEngine());
            e.init(true, publicKey);
            String inputdata = FileUtils.readFileToString(new File(inputFilename));
            byte[] messageBytes = inputdata.getBytes();
            int len = e.getInputBlockSize();
            for (int i = 0; i < messageBytes.length; i += e.getInputBlockSize()) {
                if (i + len > messageBytes.length) {
                    len = messageBytes.length - i;
                }
                byte[] hexEncodedCipher = e.processBlock(messageBytes, i, len);
                value = value + RSAEncryptFile.getHexString(hexEncodedCipher);
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(encryptedFilename));
            out.write(value);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

