/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.sm.entity;

import in.serosoft.sm.entity.Feature;
import in.serosoft.sm.entity.Portal;
import in.serosoft.sm.entity.VersionableEntity;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="system_modules")
@SequenceGenerator(name="generator", sequenceName="system_modules_seq")
public class SystemModule
extends VersionableEntity {
    private Portal portal;
    private SystemModule systemModule;
    private String displayCode;
    private String moduleName;
    private String moduleDesc;
    private Set<Feature> features = new HashSet<Feature>(0);
    private Set<SystemModule> systemModules = new HashSet<SystemModule>(0);

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="portalId", nullable=false)
    public Portal getPortal() {
        return this.portal;
    }

    public void setPortal(Portal portal) {
        this.portal = portal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parentId", nullable=false)
    public SystemModule getSystemModule() {
        return this.systemModule;
    }

    public void setSystemModule(SystemModule systemModule) {
        this.systemModule = systemModule;
    }

    @Column(name="displayCode", nullable=false, length=20)
    public String getDisplayCode() {
        return this.displayCode;
    }

    public void setDisplayCode(String displayCode) {
        this.displayCode = displayCode;
    }

    @Column(name="moduleName", nullable=false, length=20)
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Column(name="moduleDesc", length=35)
    public String getModuleDesc() {
        return this.moduleDesc;
    }

    public void setModuleDesc(String moduleDesc) {
        this.moduleDesc = moduleDesc;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="systemModule", cascade={CascadeType.ALL})
    public Set<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Set<Feature> features) {
        this.features = features;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="systemModule", cascade={CascadeType.ALL})
    public Set<SystemModule> getSystemModules() {
        return this.systemModules;
    }

    public void setSystemModules(Set<SystemModule> systemModules) {
        this.systemModules = systemModules;
    }
}

