/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.sm.service.impl;

import in.serosoft.CriteriaBuilderConfigurer.DataConfigurerApp;
import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import in.serosoft.cb.entity.UITranslation;
import in.serosoft.sm.dao.UITranslationDao;
import in.serosoft.sm.service.UITranslationService;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="UITranslationService")
public class UITranslationServiceImpl
implements UITranslationService {
    @Autowired
    UITranslationDao uiTranslationDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void generateTranslationFile() {
        Map<String, List<String>> st = this.uiTranslationDao.getTranslationData();
        Path propertiesFilePath = DataConfigurerApp.createDir(PropertiesFileManager.OUTPUT_DIRECTORY, "jsFiles");
        for (Map.Entry<String, List<String>> entrySet : st.entrySet()) {
            try {
                String filePrefix = entrySet.getKey() == null ? "" : entrySet.getKey() + "_";
                String fileName = filePrefix + "translations.js";
                System.out.println("transalation file name: " + fileName);
                List<String> values = entrySet.getValue();
                Path newFilePath = propertiesFilePath.resolve(fileName);
                Files.deleteIfExists(newFilePath);
                try {
                    OutputStream writer = Files.newOutputStream(newFilePath, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        for (String value : values) {
                            writer.write(value.getBytes());
                        }
                        System.out.println(newFilePath.toString() + " Generated successfully.");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("Error writing data to file: " + fileName);
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("completed");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateTranslationFromFile(String code) {
        StringBuilder contentBuilder = new StringBuilder();
        String filePath = "/opt/serosoft/v2_uploads/converted/translations.js";
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
            String[] a = contentBuilder.toString().split("};");
            Map<String, JSONObject> map = null;
            map = UITranslationServiceImpl.toJSONMap(a);
            for (Map.Entry<String, JSONObject> valueMap : map.entrySet()) {
                JSONObject o = valueMap.getValue();
                for (Object g : o.keySet()) {
                    String objectName = valueMap.getKey();
                    String keyName = g.toString();
                    String value = o.get(g.toString()).toString();
                    UITranslation uiTranslation = new UITranslation();
                    if (value.contains("&#39;")) {
                        value = value.replace("&#39;", "'");
                    }
                    uiTranslation.setSpanLanguage(value);
                    uiTranslation.setObjectName(objectName);
                    uiTranslation.setKeyName(keyName);
                    this.uiTranslationDao.updateTranslationFromFile(uiTranslation);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, JSONObject> toJSONMap(String[] string) {
        HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
        for (int i = 0; i < string.length; ++i) {
            try {
                String b = string[i] + "}";
                if (string[i].length() <= 1) continue;
                int indexLength = string[i].indexOf("={");
                String objectKey = b.substring(0, indexLength);
                String value = b.substring(indexLength + 1);
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON(value);
                map.put(objectKey.trim(), jsonObject);
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public void cleanUp(Path path) throws NoSuchFileException, DirectoryNotEmptyException, IOException {
        Files.delete(path);
    }
}

