/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.UUID;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MapTransaction;
import org.modeshape.graph.connector.inmemory.InMemoryNode;
import org.modeshape.graph.connector.inmemory.InMemoryRepository;
import org.modeshape.graph.connector.inmemory.InMemoryWorkspace;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

@NotThreadSafe
public class InMemoryTransaction
extends MapTransaction<InMemoryNode, InMemoryWorkspace> {
    private final InMemoryRepository repository;
    private final Lock lock;

    protected InMemoryTransaction(ExecutionContext context, InMemoryRepository repository, UUID rootNodeUuid, Lock lock) {
        super(context, repository, rootNodeUuid);
        this.repository = repository;
        this.lock = lock;
        assert (this.lock != null);
    }

    @Override
    public InMemoryWorkspace getWorkspace(String name, InMemoryWorkspace originalToClone) {
        if (originalToClone != null) {
            return new InMemoryWorkspace(name, originalToClone);
        }
        return new InMemoryWorkspace(name, new InMemoryNode(this.repository.getRootNodeUuid()));
    }

    @Override
    public boolean destroyWorkspace(InMemoryWorkspace workspace) {
        return true;
    }

    @Override
    protected InMemoryNode createNode(UUID uuid, Path.Segment name, UUID parentUuid, Iterable<Property> properties) {
        return new InMemoryNode(uuid, name, parentUuid, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            super.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this.lock.unlock();
        }
    }
}

