CREATE TABLE `person_research_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amountGranted` double DEFAULT NULL,
  `authorName` varchar(255) DEFAULT NULL,
  `dateOfUCSubmission` date DEFAULT NULL,
  `fundType` varchar(255) DEFAULT NULL,
  `fundingAgencyName` varchar(255) DEFAULT NULL,
  `impactFactor` varchar(255) DEFAULT NULL,
  `isbnNumber` varchar(255) DEFAULT NULL,
  `issueNo` varchar(255) DEFAULT NULL,
  `journalName` varchar(255) DEFAULT NULL,
  `otherAuthorName` varchar(255) DEFAULT NULL,
  `pageNumber` int(11) DEFAULT NULL,
  `projectType` varchar(255) DEFAULT NULL,
  `publisherName` varchar(255) DEFAULT NULL,
  `researchDate` date DEFAULT NULL,
  `researchDetails` varchar(255) DEFAULT NULL,
  `researchGroup` varchar(255) DEFAULT NULL,
  `researchTitle` varchar(255) DEFAULT NULL,
  `tenure` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `volumeNo` varchar(255) DEFAULT NULL,
  `whetherInstituteAffiliation` tinyint(1) DEFAULT NULL,
  `whetherUCSubmitted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `journalTypeId` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `publicationYearId` bigint(20) DEFAULT NULL,
  `researchTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_research_publication_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personResearchId` bigint(20) DEFAULT NULL,
  `publicationIndex` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_research_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `personResearchId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_seminar_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `conferenceType` varchar(255) DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `numberOfDays` int(11) DEFAULT NULL,
  `organizedBy` varchar(255) DEFAULT NULL,
  `otherDetails` varchar(255) DEFAULT NULL,
  `placeOfSeminar` varchar(255) DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `seminarTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_seminar_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `personSeminarId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `person_patent_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `dateOfPatentAwarded` date DEFAULT NULL,
  `dateOfPatentFiled` date DEFAULT NULL,
  `otherDetails` varchar(255) DEFAULT NULL,
  `patentName` varchar(255) DEFAULT NULL,
  `patentType` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_patent_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `personPatentId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE `person_training_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `fromDate` date DEFAULT NULL,
  `organisationName` varchar(255) DEFAULT NULL,
  `toDate` date DEFAULT NULL,
  `trainingSpecialization` varchar(255) DEFAULT NULL,
  `trainingStatus` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  `trainingTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_training_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `personTrainingId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_consultancy_details_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `clientName` varchar(255) DEFAULT NULL,
  `consultancyDetails` varchar(255) DEFAULT NULL,
  `place` varchar(255) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `personId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `person_consultancy_documents_history` (
  `id` bigint(20) NOT NULL,
  `REV` bigint(20) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `lastUpdate` datetime DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `personConsultancyId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
