CREATE TABLE lesson_plan_duration_history (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  itemCode varchar(255) NOT NULL,
  itemValue varchar(255) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE objective_history (
  id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  itemCode varchar(255) NOT NULL,
  itemValue varchar(255) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE = InnoDB DEFAULT CHARSET = utf8;

create table lesson_plan_history(id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  academicTermId bigint(20) NOT NULL,
  courseId bigint(20) NOT NULL,
  facultyId bigint(20) NOT NULL,
  unitTitle varchar(255) not null,
  topics  varchar(255) not null,
  term varchar(50) not null,
  durationId bigint(20) not null,
  aim text not null,
  preRequisites text,
  dateOfPlan date not null,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE = InnoDB DEFAULT CHARSET = utf8;

create table lesson_plan_course_variant_history(id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  lessonPlanId bigint(20) NOT NULL,
  courseVariantId bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE = InnoDB DEFAULT CHARSET = utf8;

create table lesson_plan_objective_history(id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  lessonPlanId bigint(20) NOT NULL,
  isSubObjectiveRequired boolean,
  remark text,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE = InnoDB DEFAULT CHARSET = utf8;

create table lesson_plan_sub_objective_history(id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  lessonPlanObjectiveId bigint(20) NOT NULL,
  SubObjectiveId bigint(20) NOT NULL,
  remark text,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE = InnoDB DEFAULT CHARSET = utf8;

create table lesson_plan_document_history(id bigint(20) NOT NULL AUTO_INCREMENT,
  REV int(11) NOT NULL,
  REVTYPE tinyint(4) DEFAULT NULL,
  lessonPlanId bigint(20) NOT NULL,
  documentId bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  PRIMARY KEY (id, REV)) ENGINE = InnoDB DEFAULT CHARSET = utf8;