DELIMITER $$

DROP PROCEDURE IF EXISTS V202001221220__AlterBillHeaderHistory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001221220__AlterBillHeaderHistory()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  
   IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='bill_header_history' 
  AND column_name='billCurrencyId')) THEN
	ALTER TABLE `bill_header_history` 
		ADD COLUMN `billCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrConvertedAmount`;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001221220__AlterBillHeaderHistory() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001221220__AlterBillHeaderHistory $$
 
DELIMITER ;

