DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291907__AlterReceiptHeaderAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291907__AlterReceiptHeaderAudit()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='receipt_header_history')) THEN
  
	ALTER TABLE `receipt_header_history` 
		ADD COLUMN `acadLocCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `cancellationDate`,
		ADD COLUMN `orgCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConversionId`,
		ADD COLUMN `acadLocCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `orgCurrencyConversionId`,
		ADD COLUMN `orgCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrConvertedAmount`,
		ADD COLUMN `acadLocCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrConvertedAmount`,
		ADD COLUMN `orgCurrencyId` BIGINT(20) NULL AFTER `acadLocCurrencyId`;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291907__AlterReceiptHeaderAudit() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291907__AlterReceiptHeaderAudit $$
 
DELIMITER ;