DELIMITER $$
DROP PROCEDURE IF EXISTS V20200506164609__Create_AttainmentRuleAndLevelAuditZurich $$
CREATE PROCEDURE V20200506164609__Create_AttainmentRuleAndLevelAuditZurich()
BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attainment_rule_history')) THEN 
		CREATE TABLE `attainment_rule_history` (
		  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		  `name` VARCHAR(45) NOT NULL,
		  `REV` int(11) NOT NULL,
		  `REVTYPE` tinyint(4) DEFAULT NULL,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attainment_level_history')) THEN 
		CREATE TABLE `attainment_level_history` (
		  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
		  `name` VARCHAR(45) NOT NULL,
		  `levelValue` DOUBLE NOT NULL,
		  `percentageRangeFrom` DOUBLE NOT NULL,
		  `percentageRangeTo` DOUBLE NOT NULL,
		  `attainmentRuleId` BIGINT(20) NOT NULL,
		  `REV` int(11) NOT NULL,
		  `REVTYPE` tinyint(4) DEFAULT NULL,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`,`REV`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	END IF; 

END $$
CALL V20200506164609__Create_AttainmentRuleAndLevelAuditZurich () $$ 
DROP PROCEDURE IF EXISTS V20200506164609__Create_AttainmentRuleAndLevelAuditZurich $$ 
DELIMITER ;