DROP PROCEDURE IF EXISTS V20250905081420__Alter_AlterUserSocialHistory;

DELIMITER $$

CREATE PROCEDURE V20250905081420__Alter_AlterUserSocialHistory()
BEGIN
    -- Add isSsoInactivated if missing
    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME = 'users_social_history'
          AND COLUMN_NAME = 'isSsoInactivated'
    ) THEN
        ALTER TABLE users_social_history
        ADD COLUMN isSsoInactivated TINYINT(1) DEFAULT 0;
    END IF;

    -- Add inactivationError if missing
    IF NOT EXISTS (
        SELECT 1
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE()
          AND TABLE_NAME = 'users_social_history'
          AND COLUMN_NAME = 'inactivationError'
    ) THEN
        ALTER TABLE users_social_history
        ADD COLUMN inactivationError VARCHAR(1024) DEFAULT NULL;
    END IF;
END$$

DELIMITER ;

CALL V20250905081420__Alter_AlterUserSocialHistory();

DROP PROCEDURE IF EXISTS V20250905081420__Alter_AlterUserSocialHistory;