DELIMITER $$

DROP PROCEDURE IF EXISTS V20251007145241__Alter_History_Ceremony_ApprDate_EffecDate $$
CREATE PROCEDURE V20251007145241__Alter_History_Ceremony_ApprDate_EffecDate()
BEGIN
    -- Check if table 'ceremony_history' exists
    IF EXISTS (
        SELECT * 
        FROM information_schema.TABLES 
        WHERE table_schema = DATABASE() 
          AND table_name = 'ceremony_history'
    ) THEN 

        -- Add 'effectivePassoutDate' column if not exists
        IF NOT EXISTS (
            SELECT * 
            FROM information_schema.COLUMNS 
            WHERE table_schema = DATABASE() 
              AND table_name = 'ceremony_history' 
              AND column_name = 'effectivePassoutDate'
        ) THEN 
            ALTER TABLE ceremony_history 
            ADD COLUMN effectivePassoutDate DATE DEFAULT NULL;
        END IF;

        -- Add 'approvalDate' column if not exists
        IF NOT EXISTS (
            SELECT * 
            FROM information_schema.COLUMNS 
            WHERE table_schema = DATABASE() 
              AND table_name = 'ceremony_history' 
              AND column_name = 'approvalDate'
        ) THEN 
            ALTER TABLE ceremony_history 
            ADD COLUMN approvalDate DATE DEFAULT NULL;
        END IF;

    END IF;
END $$

CALL V20251007145241__Alter_History_Ceremony_ApprDate_EffecDate() $$
DROP PROCEDURE IF EXISTS V20251007145241__Alter_History_Ceremony_ApprDate_EffecDate $$
DELIMITER ;
