CREATE TABLE `application_prog_approval_reasons` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `value` varchar(255) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_user` (`lastUpdatedBy`),
  CONSTRAINT `fk_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE TABLE `application_prog_rejection_reasons` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(255) DEFAULT NULL,
  `value` VARCHAR(255) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_user_rejection` (`lastUpdatedBy`),
  CONSTRAINT `fk_user_rejection` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);

CREATE TABLE `application_prog_withdraw_reasons` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `code` VARCHAR(255) DEFAULT NULL,
  `value` VARCHAR(255) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_user_withdraw` (`lastUpdatedBy`),
  CONSTRAINT `fk_user_withdraw` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);


ALTER TABLE `admission` DROP COLUMN `academyLocationId`, DROP COLUMN `personId`, DROP COLUMN `programBatchPeriodConfigId`,
DROP COLUMN `programBatchSeatConfigId`, DROP COLUMN `academicYearFor`, DROP COLUMN `distanceTravel`, DROP COLUMN `whetherTrialAdmission`, 
DROP COLUMN `trialClosureDate`, DROP COLUMN `trialRejectDate`, DROP COLUMN `offerDate`, DROP COLUMN `offerValidity`, DROP COLUMN `joiningDate`, 
DROP COLUMN `age`, DROP COLUMN `statusReason`, DROP COLUMN `additionalReqDetails`, DROP COLUMN `additionalReqCompleted`, DROP COLUMN `outstandingAmount`,
DROP COLUMN `admissionConfirmed`, DROP COLUMN `lastReceiptId`, DROP COLUMN `activeTillDate`, DROP COLUMN `suspendedTillDate`,
DROP COLUMN `applicationId`,
DROP INDEX `Refreceipt_header1716`,
DROP INDEX `Refprog_batch_period_config899`,
DROP INDEX `Refprog_batch_seat_config900`,
DROP INDEX `Refacademy_location901`,
DROP FOREIGN KEY `Refacademy_location901`,
DROP FOREIGN KEY `Refprog_batch_period_config899`, DROP FOREIGN KEY `Refprog_batch_seat_config900`, DROP FOREIGN KEY `Refreceipt_header1716`,
DROP INDEX `Refapplication_form434`, DROP FOREIGN KEY `Refapplication_form434`;